<?php

namespace App\Packages\ArticleCat;

use App\Packages\ArticleCat\Models\ArticleCat;
use App\Packages\ArticleCat\Models\Product;
use App\Packages\ArticleCat\Requests\ArticleCatRequest;
use App\Packages\ArticleCat\Requests\InquiryRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class ArticleCatController extends BaseController
{
    public $cTitle = 'Haber Kategorileri';

    public $cMenuKey = 'article_cat';
    public $cModel = ArticleCat::class;
    public $cModelName = 'Kategori';

    public $cKey = 'article_cat';

    public $cIndexBlade = "ArticleCat::index";
    public $cIndexRoute = 'admin.article_cat.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'article_cat.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.article_cat.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.article_cat.store';
    public $cCreatePermission = 'article_cat.create';
    public $cCreateBlade = 'ArticleCat::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.article_cat.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.article_cat.update';
    public $cEditPermission = 'article_cat.edit';
    //endregion

    public $cOrderMediaRoute = 'admin.article_cat.ordermedia';
    public $cUpdateMediaRoute = 'admin.article_cat.updatemedia';
    public $cDeleteMediaRoute = 'admin.article_cat.deletemedia';


    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.article_cat.orderable';


    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.article_cat.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'article_cat.publish';
    //endregion


    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.article_cat.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'article_cat.delete';
    //endregion

    public $cFields = [
        'id'        => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'   => ['name' => 'Kategori Adı'],
        'parent_id' => ['name' => 'İlişkili Kategori', 'size' => 'medium'],
        'lock'      => ['name' => 'Kilitli', 'size' => 'mini'],
    ];

    public $cFieldMutators = [
//        'article_cat_id' => 'videoArticleCatName',
        'created_at' => 'globalDate',
        'parent_id'  => ['method' => 'parentName', 'parameter' => 'object'],
        'name'       => ['method' => 'frontUrl', 'parameter' => 'object'],
        'lock'       => 'isLocked',
    ];

    public $cSidebarModules = [
        'ArticleCat::_partials.status',
        'ArticleCat::_partials.article_cat',
        'admin::_partials.sidebar.elements.page',
    ];


    public $cModuleFiles = [];

    public $cFilterable = true;

    public $filters = [
        'name_tr' => [
            'name'     => 'Kategori Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public function __construct()
    {
        view()->share('article_cats', ArticleCat::published()->get()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }

    public function store(ArticleCatRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(ArticleCatRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
