<?php

Route::group(['prefix' => 'article', 'as' => 'article.','namespace' => 'App\Packages\Article'], function () {
    Route::get('/',                                 ['as' => 'index',           'uses' => 'ArticleController@index']);
    Route::get('/create',                           ['as' => 'create',          'uses' => 'ArticleController@create']);
    Route::post('/',                                ['as' => 'store',           'uses' => 'ArticleController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',            'uses' => 'ArticleController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',          'uses' => 'ArticleController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',         'uses' => 'ArticleController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy',         'uses' => 'ArticleController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy',    'uses' => 'ArticleController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable',       'uses' => 'ArticleController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',            'uses' => 'ArticleController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',      'uses' => 'ArticleController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',     'uses' => 'ArticleController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',     'uses' => 'ArticleController@deleteMedia']);
});
