<?php

namespace App\Packages\Article\Models;

use App\Packages\ArticleCat\Models\ArticleCat;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Multilingual\Traits\MultiLingualModel;
use Nette\Upload\Models\Media;

class Article extends BaseModel
{
    use SoftDeletes;
    use Sluggable;
    use SlugTrait;
    use MultiLingualModel;

    protected $fillable = ['photo_id', 'cover_id', 'status', 'meta', 'created_at', 'number_of_reads', 'status_type', 'article_cat_id', 'bc_id'];

    protected $multiLingualFillable = [
        'name',
        'slug',
        'content',
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    public static $checks = [
        'status',
        'status_type',
    ];

    protected $with = ['photo', 'cover', 'bc'];


    protected $appends = [];

    public static $rules = [];

    public static $multiLingualRules = [
        'name'    => 'required',
        'content' => 'required',
    ];

    public static $attr = [
        'name'    => 'Başlık',
        'content' => 'Açıklama',
    ];

    public function category()
    {
        return $this->hasOne(ArticleCat::class, "id", "article_cat_id");
    }

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto($variation = null)
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : asset('special/no-image.jpg');
    }

    public function cover()
    {
        return $this->hasOne(Media::class, 'id', 'cover_id');
    }

    public function getCover()
    {
        return $this->cover_id ? str_replace("\\", "/", $this->cover->url()) : asset('special/no-image.jpg');
    }

    public function bc()
    {
        return $this->hasOne(Media::class, 'id', 'bc_id');
    }

    public function getBc()
    {
        return $this->bc_id ? str_replace("\\", "/", $this->bc->url()) : '#';
    }

    public function images()
    {
        return $this->belongsToMany(Media::class, 'article_galleries', 'article_id', 'media_id')->withPivot('title', 'caption', 'order',
            'source')->orderBy('article_galleries.order', 'ASC');
    }

    public function sluggable()
    {
        return $this->autoSluggable();
    }
}
