<?php

namespace App\Packages\Article;

use App\Packages\Article\Models\Article;
use App\Packages\ArticleCat\Models\ArticleCat;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use UploadManager;

use App\Packages\Article\Requests\ArticleRequest;

class ArticleController extends AdminBaseController
{
    public $cTitle = 'Blog Yazıları';
    public $cMenuKey = 'article';

    public $cBreadcrumb = [
        'name'  => 'Blog Yazıları',
        'route' => 'admin.article.index',
    ];

    public $cModel = Article::class;
    public $cModelName = 'Blog Yazıları';

    public $cKey = 'article';

    public $cBladeKey = null;

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.article.index';
    public $cIndexTitle = 'List';

    public $cShow = true;
    public $cShowRoute = 'admin.article.show';
    public $cShowTitle = 'View';
    public $cShowBlade = null;
    public $cShowPermission = 'article.view';


    public $cCreate = true;
    public $cCreateBlade = 'Article::create';
    public $cCreateRoute = 'admin.article.create';
    public $cCreateTitle = 'Yeni ';
    public $cCreateMethodRoute = 'admin.article.store';
    public $cCreatePermission = 'article.create';

    public $cEdit = true;
    public $cEditRoute = 'admin.article.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.article.update';
    public $cEditPermission = 'article.edit';

    public $cPublish = true;
    public $cPublishRoute = 'admin.article.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'article.publish';

    public $cDelete = true;
    public $cDeleteRoute = 'admin.article.destroy';
    public $cDeletePermission = 'article.delete';

    public $cBatchDelete = true;
    public $cBatchDeleteRoute = 'admin.article.batchdestroy';

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.article.orderable';

    public $cSortable = false;
    public $cSortableColumn = 'order_number';


    public $cOrderMediaRoute = 'admin.article.ordermedia';
    public $cUpdateMediaRoute = 'admin.article.updatemedia';
    public $cDeleteMediaRoute = 'admin.article.deletemedia';


    public $cFields = [
        'id'             => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'        => ['name' => 'Content Title'],
        'article_cat_id' => ['name' => 'Haber Kategorisi'],
    ];
    public $cMultiLangFields = [
        'name' => 'Name',
    ];

    public $cFieldMutators = [
        'article_cat_id' => ['method' => 'getArticleCategory', 'parameter' => 'object'],
    ];

    public $cFilterable = false;
    public $filters = [
        'field' => [
            'name'     => 'Content Title',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public $cModuleFiles = [
        [
            'name'         => 'Blog Görseli',
            'type'         => 'img',
            'key'          => 'article',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],
        [
            'name'         => 'Blog İç Görseli',
            'type'         => 'img',
            'key'          => 'cover',
            'database_key' => 'cover_id',
            'multiple'     => false,
            'attach_func'  => 'cover',
        ],[
            'name'         => 'Blog Banner Görseli',
            'type'         => 'img',
            'key'          => 'bc',
            'database_key' => 'bc_id',
            'multiple'     => false,
            'attach_func'  => 'bc',
        ],
        [
            'name'        => 'Haber Galerisi',
            'type'        => 'img',
            'key'         => 'article_galleries',
            'multiple'    => true,
            'attach_func' => 'images',
        ],
    ];

    public $cSidebarModules = [
        'Article::_common.relation',
        '_Common::status',
        'Article::_common.status',
    ];

    public function __construct()
    {
        view()->share('categories', ArticleCat::all()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }


    public function store(ArticleRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Registration Successful!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(ArticleRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }


}
