<?php

namespace App\Http\Requests;

use Nette\Contact\Models\Contact;
use App\Http\Requests\BaseRequest;

/**
 * Class ContactRequest
 * @package App\Http\Requests
 */
class ContactRequest extends BaseRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return Contact::$rules;
    }

    /**
     * @return array
     */
    public function attributes()
    {
        return [
            'name' => trans('contact.name'),
            'body' => trans('contact.message'),
            'subject' => trans('contact.subject'),
            'email' => trans('contact.email'),
            'g-recaptcha-response' => trans('contact.security_code')
        ];
    }
}
