<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use RecursiveArrayIterator;
use RecursiveIteratorIterator;

/**
 * #### Main Request ####
 * @package App\Http\Requests
 */
abstract class BaseRequest extends FormRequest
{

    protected function failedValidation(Validator $validator)
    {

        $errors = $validator->errors()->toArray();

        $it = new RecursiveIteratorIterator(new RecursiveArrayIterator($errors));
        $errors = iterator_to_array($it, false);

        $error = '• ' . implode("\n <br> • ", $errors);
        if (\Request::wantsJson()) {

            throw new HttpResponseException(response(
                ['error' => $error],
                422
            ));
        } else {
            throw new ValidationException($validator);
        }
    }
}
