<?php

namespace App\Http\Controllers;

use App\Packages\ArticleCat\Models\ArticleCat;
use App\Packages\Category\Models\Category;
use App\Packages\Cities\Models\Cities;
use App\Packages\Page\Models\Page;
use App\Packages\Product\Models\Product;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use View;
use Data;

class FrontBaseController extends Controller
{
    public function __construct()
    {
        $menuCategories = Cache::remember("menu-cats-cache", 1440, function () {
            return Category::published()->orderBy('order_number', 'ASC')->where("parent_id", 0)->where("home_showroom", 1)->get();
        });
        View::share('menuCategories', $menuCategories);

        $menuShowroomProducts = Cache::remember("menu-showroom-prods-cache", 1440, function () {
            return Product::published()->orderBy('order_number', 'ASC')->where('home_page_view', 1)->get();
        });
        View::share('menuShowroomProducts', $menuShowroomProducts);

        $basePress = Cache::remember("article-cat-cache", 1440, function () {
            return ArticleCat::published()->where("parent_id", 0)->orderBy("order_number", "ASC")->get();
        });
        View::share("basePress", $basePress);

        $configs = Cache::remember("configs-cache", 1440, function () {
            return [
                "ph1"       => _config("contact_phone"),
                "ph2"       => _config("contact_fax"),
                "mail"      => _config("contact_mail"),
                "adr"       => _config("contact_address"),
                "adrv"      => _config("contact_view_address"),
                "mk"        => _config("map_api_key"),
                "facebook"  => _config("facebook"),
                "instagram" => _config("instagram"),
                "linkedin"  => _config("linkedin"),
            ];
        });
        View::share("configs", $configs);

        $policies = Cache::remember("policies-cache", 1440, function () {
            return [
                "pdpl"      => Page::where("key", "kvkk")->first(),
                "confident" => Page::where("key", "confidentiality-agreement")->first(),
            ];
        });
        View::share("policies", $policies);

    }
}
