<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Category\Models\Category;
use App\Packages\Product\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ProductController extends FrontBaseController
{
    const VIEW = "front.products.";

    public function category($slug)
    {
        $datum = Cache::remember("category-page-specify-cat-".$slug, 1440, function () use ($slug) {
            return Category::published()->where("slug_"._clang(), $slug)->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("datum", $datum);
    }

    public function product($category_slug, $slug)
    {
        $datumCatId = Cache::remember("product-category-".$category_slug, 1440, function () use ($category_slug) {
            return Category::published()->where("slug_"._clang(), $category_slug)->first();
        });

        $datum = Cache::remember("product-page-".$category_slug."-".$slug, 1440, function () use ($datumCatId, $slug) {
            return Product::where("status", 1)->where("slug_"._clang(), $slug)->where("category_id", $datumCatId->id)->first();
        });

        ! $datum ? abort(404) : "";

        _shareMultiSlugLocalizedUrls("front.product", ["category_slug" => $datumCatId, "slug" => $datum]);

        $others = Cache::remember("product-page-others".$category_slug."-".$slug, 1440, function () use ($datumCatId, $datum) {
            return Product::where("status", 1)->where("id", "!=", $datum->id)->take(10)->get();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("datum", $datum)
            ->with("others", $others);
    }

    public function products()
    {
        $data = Cache::remember("all-products", 1440, function () {
            return Product::published()->orderBy("order_number")->get();
        });

        $styles = Cache::remember("all-products-styles", 9999, function () {
            return [
                "ino", "gurme", "tatli", "makarna",
            ];
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("data", $data)
            ->with("styleName", array_rand($styles, 1))
            ->with("styles", $styles);
    }

}
