<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Article\Models\Article;
use App\Packages\ArticleCat\Models\ArticleCat;
use App\Packages\Cities\Models\Cities;
use App\Packages\Page\Models\Page;
use App\Packages\References\Models\References;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class LocationController extends FrontBaseController
{
    const VIEW = "front.location.index";

    public function index()
    {
        return view(self::VIEW)
            ->with("cities", $this->getCities())
            ->with("onlineMarkets", $this->getOnlineMarkets())
            ->with("offlineMarkets", $this->getOfflineMarkets())
            ->with("page", Cache::remember("location-page-cache-key", 1440, function () {return Page::where("key", "location")->first();}));
    }

    public function getCities()
    {
        return Cache::remember("locations-page-cities", 1440, function () {
            return Cities::published()->orderBy("order_number")->get();
        });
    }

    public function getOnlineMarkets()
    {
        return Cache::remember("locations-page-onlinemarkets", 1440, function () {
            return References::published()->orderBy("order_number")->online()->get();
        });
    }

    public function getOfflineMarkets()
    {
        return Cache::remember("locations-page-offlinemarkets", 1440, function () {
            return References::published()->orderBy("order_number")->offline()->get();
        });
    }

}
