<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Article\Models\Article;
use App\Packages\Category\Models\Category;
use App\Packages\Page\Models\Page;
use App\Packages\References\Models\References;
use App\Packages\Slider\Models\Slider;
use App\Packages\Widget\Models\Widget;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class HomeController extends FrontBaseController
{
    const VIEW = "front.home.index";

    public function index()
    {
        return view(self::VIEW)
            ->with("sliders", $this->getSliders())
            ->with("references", $this->getReferences())
            ->with("pages", $this->getPages())
            ->with("showroomCategories", $this->getShowroomCategories())
            ->with("showroomBlogs", $this->getBlogsShowroom())
            ->with("widgets", $this->getWidgets());
    }

    public function getSliders()
    {
        return Cache::remember("home-slider", 1440, function () {
            return Slider::published()->orderBy("order_number")->get();
        });
    }

    public function getReferences()
    {
        return Cache::remember("home-references", 1440, function () {
            return References::published()->forHome()->orderBy("order_number")->get();
        });
    }

    public function getPages()
    {
        return Cache::remember("home-pages", 1440, function () {
            return [
                "references" => Page::where("key", "home-references-card")->first(),
                "widgets"    => Page::where("key", "home-widget-cards")->first(),
            ];
        });
    }

    public function getShowroomCategories()
    {
        return Cache::remember("home-showroom-categories", 1440, function () {
            return Category::published()->where("home_showroom", 1)->orderBy("order_number", "ASC")->take(4)->get();
        });
    }

    public function getBlogsShowroom()
    {
        return Cache::remember("home-showroom-blogs", 1440, function () {
            return Article::published()->orderBy("order_number")->where("status_type", 1)->take(4)->get();
        });
    }

    public function getWidgets()
    {
        return Cache::remember("home-widgets", 1440, function () {
            return Widget::published()->orderBy("order_number")->take(4)->get();
        });
    }
}
