<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Page\Models\Page;
use App\Packages\Redirect\Models\Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class GuideController extends FrontBaseController
{
    const VIEW = "front.guide.index";

    public function index()
    {
        $dataTexts = Cache::remember("cooking-guide-page-texts", 1440, function () {
            return Redirect::published()->where("link_"._clang(), null)->orderBy("order_number")->get();
        });

        $dataVideos = Cache::remember("cooking-guide-page-videos", 1440, function () {
            return Redirect::published()->where("content_"._clang(), null)->whereNotNull("link_"._clang())->get();
        });

        $page = Cache::remember("cooking-guide-page", 1440, function () {
            return Page::where("key", "cooking-guide")->first();
        });

        return view(self::VIEW)
            ->with("dataTexts", $dataTexts)
            ->with("dataVideos", $dataVideos)
            ->with("page", $page);
    }
}
