<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\FaqCat\Models\FaqCat;
use App\Packages\Page\Models\Page;
use App\Packages\Redirect\Models\Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class FaqController extends FrontBaseController
{
    const VIEW = "front.faq.index";

    public function index()
    {
        $data = Cache::remember("faq-page-data", 1440, function () {
            return FaqCat::published()->orderBy("order_number")->get();
        });

        $page = Cache::remember("faq-page-page", 1440, function () {
            return Page::where("key", "faq")->first();
        });

        return view(self::VIEW)
            ->with("data", $data)
            ->with("page", $page);
    }
}
