<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Article\Models\Article;
use App\Packages\ArticleCat\Models\ArticleCat;
use App\Packages\Cities\Models\Cities;
use App\Packages\Page\Models\Page;
use App\Packages\References\Models\References;
use App\Packages\Widget\Models\Widget;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class CorporateController extends FrontBaseController
{
    const VIEW = "front.corporate.";

    public function about()
    {
        $page = Cache::remember("about-page", 1440, function () {
            return Page::where("key", "about")->first();
        });

        $widgets = Cache::remember("about-page-widgets", 1440, function () {
            return Widget::published()->orderBy("order_number")->take(4)->get();
        });

        $horeca = Cache::remember("about-horeca-page", 1440, function () {
            return Page::where("key", "about-horeca")->first();
        });

        $retail = Cache::remember("about-retail-page", 1440, function () {
            return Page::where("key", "about-retail")->first();
        });

        $endText = Cache::remember("about-page-end-text", 1440, function () {
            return Page::where("key", "about-page-end-text")->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("page", $page)
            ->with("widgets", $widgets)
            ->with("horeca", $horeca)
            ->with("retail", $retail)
            ->with("endText", $endText);
    }

    public function values()
    {
        $page = Cache::remember("values-page", 1440, function () {
            return Page::where("key", "values-page")->first();
        });
        $val1 = Cache::remember("values-page-va-1", 1440, function () {
            return Page::where("key", "values-page-1")->first();
        });
        $val2 = Cache::remember("values-page-va-2", 1440, function () {
            return Page::where("key", "values-page-2")->first();
        });
        $val3 = Cache::remember("values-page-va-3", 1440, function () {
            return Page::where("key", "values-page-3")->first();
        });
        $val4 = Cache::remember("values-page-va-4", 1440, function () {
            return Page::where("key", "values-page-4")->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("page", $page)
            ->with("val1", $val1)
            ->with("val2", $val2)
            ->with("val3", $val3)
            ->with("val4", $val4);
    }

    public function quality()
    {
        $page1 = Cache::remember("quality-page-1", 1440, function () {
            return Page::where("key", "quality-page-1")->first();
        });

        $page2 = Cache::remember("quality-page-2", 1440, function () {
            return Page::where("key", "quality-page-2")->first();
        });

        $contactCard1 = Cache::remember("quality-contact-card1", 1440, function () {
            return Page::where("key", "quality-contact-card-1")->first();
        });

        $contactCard2 = Cache::remember("quality-contact-card2", 1440, function () {
            return Page::where("key", "quality-contact-card-2")->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("page1", $page1)
            ->with("contactCard1", $contactCard1)
            ->with("page2", $page2)
            ->with("contactCard2", $contactCard2);
    }

    public function why()
    {
        $page = Cache::remember("why-page", 1440, function () {
            return Page::where("key", "why-page1")->first();
        });

        $page2 = Cache::remember("why-page2", 1440, function () {
            return Page::where("key", "why-page2")->first();
        });

        $page3 = Cache::remember("why-page3", 1440, function () {
            return Page::where("key", "why-page3")->first();
        });

        $page4 = Cache::remember("why-page4", 1440, function () {
            return Page::where("key", "why-page4")->first();
        });

        $page5 = Cache::remember("why-page5", 1440, function () {
            return Page::where("key", "why-page5")->first();
        });

        $page6 = Cache::remember("why-page6", 1440, function () {
            return Page::where("key", "why-page6")->first();
        });

        $page7 = Cache::remember("why-page7", 1440, function () {
            return Page::where("key", "why-page7")->first();
        });

        $page8 = Cache::remember("why-page8", 1440, function () {
            return Page::where("key", "why-page8")->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("page", $page)
            ->with("page2", $page2)
            ->with("page3", $page3)
            ->with("page4", $page4)
            ->with("page5", $page5)
            ->with("page6", $page6)
            ->with("page7", $page7)
            ->with("page8", $page8);
    }

    public function career()
    {
        $page = Cache::remember("career-page", 1440, function () {
            return Page::where("key", "career-page")->first();
        });

        return view(self::VIEW.__FUNCTION__)
            ->with("page", $page);
    }


}
