<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\FrontBaseController;
use App\Packages\Article\Models\Article;
use App\Packages\ArticleCat\Models\ArticleCat;
use App\Packages\Page\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class BlogController extends FrontBaseController
{
    const VIEW = "front.blog.";

    public function blogs()
    {
        return view(self::VIEW.__FUNCTION__)
            ->with("type", __FUNCTION__)
            ->with("page", $this->getPage(__FUNCTION__))
            ->with("data", $this->getElements(__FUNCTION__, 3));
    }

    public function news()
    {
        return view(self::VIEW.__FUNCTION__)
            ->with("type", __FUNCTION__)
            ->with("page", $this->getPage(__FUNCTION__))
            ->with("data", $this->getElements(__FUNCTION__, 4));
    }

    public function activities()
    {
        return view(self::VIEW.__FUNCTION__)
            ->with("type", __FUNCTION__)
            ->with("page", $this->getPage(__FUNCTION__))
            ->with("data", $this->getElements(__FUNCTION__, 5));
    }

    public function getPage($key)
    {
        return Page::where("key", $key)->first();
    }

    public function getElements($key, $id)
    {
        return ArticleCat::published()->where("id", $id)->first();
    }

    public function blog($slug)
    {
        $datum = Article::published()->where("slug_"._clang(), $slug)->first();
        ! $datum ? abort(404) : "";

        _shareMultiSlugLocalizedUrls("front.blog", ["slug" => $datum]);

        $others = Article::published()->orWhere("article_cat_id", [6, 7, 8])->take(4)->get();

        return view(self::VIEW.__FUNCTION__)
            ->with("type", __FUNCTION__)
            ->with("datum", $datum)
            ->with("others", $others);
    }

    public function new($slug)
    {
        $datum = Article::published()->where("article_cat_id", 4)->where("slug_"._clang(), $slug)->first();

        ! $datum ? abort(404) : "";

        _shareMultiSlugLocalizedUrls("front.new", ["slug" => $datum]);

        $others = Article::published()->where("article_cat_id", 4)->take(4)->get();

        return view(self::VIEW."blog")
            ->with("type", __FUNCTION__)
            ->with("datum", $datum)
            ->with("others", $others);
    }

    public function activity($slug)
    {
        $datum = Article::published()->where("article_cat_id", 5)->first();

        ! $datum ? abort(404) : "";

        _shareMultiSlugLocalizedUrls("front.activity", ["slug" => $datum]);

        $others = Article::published()->where("article_cat_id", 5)->take(4)->get();

        return view(self::VIEW."blog")
            ->with("type", __FUNCTION__)
            ->with("datum", $datum)
            ->with("others", $others);
    }


}
