<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediaPackage extends Migration
{

    public function up()
    {
        Schema::create('media', function(Blueprint $table)
        {
            $table->engine = 'InnoDB';

            $table->bigIncrements('id');

            $table->string('uuid');

            $table->string('folder');
            $table->string('ext',10);

            $table->enum('type',['img','doc','vid','other'])->default('img');
            $table->string("key")->nullable();

            $table->string('name')->nullable();
            $table->text('data')->nullable();

            $table->bigInteger("size")->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('media');
    }
}
