<?php

if (!function_exists('skey')) {
    function skey($force_key = null)
    {
        $uuid = \Ramsey\Uuid\Uuid::uuid4();
        if ($force_key) {
            $uuid = $force_key;
        }
        return '<input name="_skey" type="hidden" value="' . ((is_null($force_key)) ? (old('_skey') ?: $uuid) : $uuid) . '">';
    }
}

if (!function_exists('skey_meta')) {
    function skey_meta($force_key = null)
    {
        $uuid = \Ramsey\Uuid\Uuid::uuid4();
        if ($force_key) {
            $uuid = $force_key;
        }
        return '<meta name="csrf-skey" content="' . ((is_null($force_key)) ? (old('_skey') ?: $uuid) : $uuid) . '">';

    }
}

if (!function_exists('joinPaths')) {
    function joinPaths()
    {
        $args = func_get_args();
        $paths = array();
        foreach ($args as $arg) {
            $paths = array_merge($paths, (array)$arg);
        }

        $paths = array_map(create_function('$p', 'return trim($p, "/");'), $paths);
        $paths = array_filter($paths);
        return join('/', $paths);
    }
}

if (!function_exists('deleteMedia')) {
    function deleteMedia($id)
    {
        $disk = config('upload.disk');
        if ($id != null && is_numeric($id)) {
            $media = \Nette\Upload\Models\Media::find($id);
            $mediaType = $media->type;
            if ($media) {
                $mediaData = clone $media;
                if (!$media->delete()) {
                    return response()->json(result(false));
                } else {

                    $variations = config("upload.{$mediaType}.keys.{$mediaData->key}.variations");
                    if ($variations && count($variations)) {
                        foreach ($variations as $variation_key => $variation) {
                            \Illuminate\Support\Facades\Storage::disk($disk)->delete(config("upload.{$mediaType}.uploadPath") . $mediaData->folder . DIRECTORY_SEPARATOR . $mediaData->uuid . '-' . $variation_key . '.' . $mediaData->ext);
                        }
                    }

                    \Illuminate\Support\Facades\Storage::disk($disk)->delete(config("upload.{$mediaType}.uploadPath") . $mediaData->folder . DIRECTORY_SEPARATOR . $mediaData->uuid . '.' . $mediaData->ext);

                    return response()->json(result(true));
                }
            } else {
                return response()->json(result(false));
            }
        } else {
            return response()->json(result(false));
        }
    }
}

if (!function_exists('getFileSize')) {
    function getFileSize($size = 0, $precision = 2)
    {
        if ($size > 0) {
            $size = (int)$size;
            $base = log($size) / log(1024);
            $suffixes = ['BYTE', 'KB', 'MB', 'GB', 'TB'];

            return round(pow(1024, $base - floor($base)), $precision) . $suffixes[floor($base)];
        } else {
            return $size;
        }
    }
}

if (!function_exists('result')) {
    function result($result, $action = null)
    {
        return (object)['result' => (bool)$result, 'action' => $action];
    }
}

if (!function_exists('uploader')) {
    function uploader(
        $type = 'doc',
        $key = null,
        $title = 'Yükleme',
        $config = '',
        $function = 'media',
        $preview = null,
        $multiple = false,
        $items = null,
        $orderurl = null,
        $updateurl = null,
        $deleteurl = null
    )
    {
        if (!in_array($type, ['img', 'doc', 'vid'])) {
            $type = 'doc';
        }

        if (!$key) {
            return html()->span('Tip Belirtilmedi');
        }

        $previewUrl = null;

        if (is_object($preview) && get_class($preview) === \Nette\Upload\Models\Media::class) {
            if ($preview->type == 'img') {
                $previewUrl = $preview->url();
            } else {
                $previewUrl = $preview->name;
            }
        } else {
            $previewUrl = $preview;
        }

        return html()->element('hr')->class('n-uploader')
            ->data('type', $type)
            ->data('key', $key)
            ->data('title', $title)
            ->data('config', json_encode(config("upload.{$type}.keys.{$config}", [])))
            ->data('function', $function)
            ->data('preview', $previewUrl)
            ->data('multiple', $multiple ? 'true' : 'false')
            ->data('items', json_encode($items ?? []))
            ->data('orderurl', $orderurl)
            ->data('updateurl', $updateurl)
            ->data('deleteurl', $deleteurl);
    }
}

if (!function_exists('mediaSetGenerator')) {
    function mediaSetGenerator($item, $altText = null, $variationOriginalPrefix = 'responsive', $sort = 'asc', $customClass = null, $relation = 'photo', $noimageSuffix = null): string
    {

        if (isset($item['pivot'])) {
            $photoItem = $item;
            $mediaKey = $item['key'];
        } else {
            if (isset($item[$relation])) {
                $photoItem = $item[$relation];
                $mediaKey = $item[$relation]['key'];
            } else {
                return "<img src=\"" . _asset('images/no-image' . ($noimageSuffix ? ('-' . $noimageSuffix) : '') . '.png') . "\" alt=\"" . $altText . "\"/>\n";
            }
        }

        $imageVariations = [];
        $originalPhotoVariation = null;
        $pictureElementsForNonScript = '';
        $variationPrefix = $variationOriginalPrefix . '-';
        $pictureElements = "<picture>\n";
        if (!is_null($altText)) {
            $altText = htmlspecialchars($altText, ENT_QUOTES);
        }

        $imageVariations = preg_filter('/^' . $variationPrefix . '(.*)/', '$1', array_keys(config('upload.img.keys.' . $mediaKey . '.variations')));

        if ($imageVariations && count($imageVariations) > 0) {

            if ($sort == 'asc') {
                rsort($imageVariations);
            } else {
                ksort($imageVariations);
            }

            $originalPhotoVariation = $variationPrefix . end($imageVariations);
            array_pop($imageVariations);

            foreach ($imageVariations as $imageVariation) {
                $imageWidth = config('upload.img.keys.' . $mediaKey . '.variations.' . $variationPrefix . $imageVariation . '.resolution') ?? 0;
                $imageWidths = config('upload.img.keys.' . $mediaKey . '.variations.' . $variationPrefix . $imageVariation . '.width') ?? 0;
                $pictureElements .= "<source media=\"(max-width: " . $imageWidth . 'px' . ")\" data-srcset=\"" . getMedia($photoItem, $variationPrefix . $imageVariation) . "\">\n";;
                $pictureElementsForNonScript .= "<source media=\"(max-width: " . $imageWidth . 'px' . ")\" srcset=\"" . getMedia($photoItem, $variationPrefix . $imageVariation) . "\">\n";;
            }

        } else {
            $imageVariation = config('upload.img.keys.' . $mediaKey . '.variations.' . $variationOriginalPrefix);
            if ($imageVariation) {
                $originalPhotoVariation = $variationOriginalPrefix;
            }
        }
        $defaultClass = 'b-lazy ' . $customClass;
        $defaultClass = ' class="' . $defaultClass . '" ';

        if (!is_null($customClass)) {
            $customClass = ' class="' . $customClass . '" ';
        }

        $mediaWidth = config('upload.img.keys.' . $mediaKey . '.variations.' . ($variationPrefix && count($imageVariations) > 0 ? $originalPhotoVariation : $variationOriginalPrefix) . '.width');

        $mediaHeight = config('upload.img.keys.' . $mediaKey . '.variations.' . ($variationPrefix && count($imageVariations) > 0 ? $originalPhotoVariation : $variationOriginalPrefix) . '.height');


        $pictureElements .= "<img" . $defaultClass . " data src=\"" . _asset('images/lazy.gif') . "\" data-src=\"" . getMedia($photoItem, $originalPhotoVariation) . "\"  alt=\"" . $altText . "\" wıdth=\"" . $mediaWidth . "\" height=\"" . $mediaHeight . "\" />\n";

        $pictureElements .= "</picture>\n";

        $pictureElements .= '
            <noscript>
                <picture>
                    ' . $pictureElementsForNonScript . '
                    <img ' . $customClass . ' src="' . getMedia($photoItem, $originalPhotoVariation) . '" alt="' . $altText . '" />
                </picture>
            </noscript>';

        return $pictureElements;

    }
}

if (!function_exists('getFileExtensionWithType')) {
    function getFileExtensionWithType($type)
    {
        $mimeTypes = [
            "image/jpeg" => "jpg",
            "image/svg+xml" => "svg",
            "image/png" => "png",
            "image/gif" => "gif",
        ];
        if (isset($mimeTypes[$type])) {
            return $mimeTypes[$type];
        }

        return 'jpg';
    }
}

if (!function_exists('render_uploader')) {
    function render_uploader($key, $item = null)
    {
        $files = view()->shared('cModuleFiles') ?? [];

        if ($files[$key] ?? false) {
            $moduleFile = $files[$key];
            return
                uploader(
                    $moduleFile['type'],
                    $moduleFile['key'],
                    $moduleFile['name'],
                    $moduleFile['key'],
                    (isset($item) ? $moduleFile['attach_func'] : null),
                    (isset($item) ? $item->{$moduleFile['attach_func']} : null)
                );

        }
    }
}


if (!function_exists('getMedia')) {
    function getMedia($data, $variation = null)
    {
        if ($data) {
            // ElasticSearch e attığımız relational child modeller jsonlanıyor. Bu yüzden child media modellerinin verisi Media Modellerine çevirilmiyor.
            // Bu durumda bizim ekstradan sorgu yaratmamak ve performans artışı sağlamak için varolan datadan mediadaki get metodunu simule edecek dosyayı getMedia ile kullanacağız.
            if (!is_null($variation)) {
                $variation = '-' . $variation;
            }
            if (is_array($data) && count($data) > 0) {
                return url('upload' . DIRECTORY_SEPARATOR . config("upload.{$data['type']}.uploadPath") . $data['folder'] . DIRECTORY_SEPARATOR . $data['uuid'] . $variation . ".{$data['ext']}");
            } else if (get_class($data) == 'Nette\Upload\Models\Media') {
                return $data->url($variation);
            }

        }

        return _asset('images/no-image-square.png');
    }
}