<?php

namespace Nette\Upload\Models;

use Illuminate\Database\Eloquent\Model as Model;

class Media extends Model
{
    public $table = 'media';
    public $fillable = ['folder', 'ext', 'type', 'key', 'name', 'data', 'size', 'uuid'];

    public function get()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'uuid' => $this->uuid,
            'ext' => $this->ext,
            'dir' => $this->folder
        ];
    }

    protected $appends = ['url'];

    public function url($variation = null)
    {
        $diskPath = config('filesystems.disks.upload.path', 'upload');
        return url($diskPath . DIRECTORY_SEPARATOR . config("upload.{$this->type}.uploadPath") . $this->folder . DIRECTORY_SEPARATOR . $this->uuid . (isset($variation) ? '-' . ltrim($variation, '-') : '') . ".{$this->ext}");
    }

    public function getUrlAttribute()
    {
        return $this->url();
    }
}


