<?php

namespace Nette\Upload\Libraries;

use Config;
use Nette\Upload\Models\Media;
use File;
use Image;
use Ramsey\Uuid\Uuid;
use Storage;

/**
 * #### Process Documents and Create Associated Models from them ####
 * @package App\Libraries\Managers
 */
class DocumentManager
{
    public $document;
    public $documentInfo;
    public $ext;
    public $format;
    public $model;
    public $type = 'doc';

    public $disk = 'upload';
    public $diskOriginal = 'upload-original';

    private $customDate = null;

    public function __construct($document,$customDate= null)
    {
        $this->document = $document['file'];

        $this->disk = config('upload.disk');
        $this->diskOriginal = config('upload.originalDisk');

        $this->customDate = $customDate;
    }

    private function determineFolder()
    {
        if($this->customDate == null) {
            return date("Y") . DIRECTORY_SEPARATOR . date('m', time()) . DIRECTORY_SEPARATOR . date('d', time());
        } else {
            return date("Y",$this->customDate) . DIRECTORY_SEPARATOR . date('m', $this->customDate) . DIRECTORY_SEPARATOR . date('d', $this->customDate);
        }
    }

    public function save()
    {
        //Config Check
        if (!Config::get("upload.doc.uploadPath")) {
            Log::error("Upload Path Undefined");
            return false;
        }

        //Document Config Check
        if (!$this->checkConfig()) {
            Log::error("Document Config Error");
            return false;
        }

        $modelUuid = Uuid::uuid4()->toString();

        $document = $this->document;
        $this->ext = $document['ext'] ?? '';
        $this->documentInfo = new \SplFileInfo($document["storageFullPath"]);

        //Determine Target Folder
        $targetDir      = $this->determineFolder();

        //Specify folder field data
        $uploadDir      = (config('upload.doc.uploadPath').$targetDir);
        $originalDir    = (config('upload.doc.uploadPath').$targetDir);

        $model = Media::create([
            'uuid'=>$modelUuid,
            'folder' => $targetDir,
            'ext' => $document["ext"],
            'type' => $this->type,
            'key' => $document["key"],
            'name' => $document['clientName'],
            'size' => 0
        ]);

        if ($model) {
            $savedDocument = $this->saveDocument($uploadDir,$originalDir, $document, $model);
            if($savedDocument){
                return $model;
            } else {
                return false;
            }
        } else {
            return false;
        }

    }


    private function checkConfig()
    {
        return true;
    }

    /*
     * Function: checkFolder()
     * Dizin adını Parametre olarak alır
     * true / false döner
     *
     *
     * Bütün Dökümanların Yükleneceği klasörü public_path içinde kontrol ederek yoksa yaratır.
     * İzinlerini 777 olarak ayarlar
     *
     */
    private function checkFolder($path,$disk)
    {

        if (!Storage::disk($disk)->exists($path)) {
            try {
                Storage::disk($disk)->makeDirectory($path);
            } catch (\Exception $ex) {
                Log::warning("Couldn't create folder $path on disk $disk");
                return false;
            }
        }


        if (!Storage::disk($this->disk)->exists($path)) {
            try {
                Storage::disk($this->disk)->makeDirectory($path);
            } catch (\Exception $ex) {
                Log::warning("Couldn't create folder $path.");
                return false;
            }
        }

        return true;

    }

    private function saveDocument($uploadDir,$originalDir,$tempFile, $model)
    {
        try {
            if ($this->checkFolder($uploadDir, $this->disk) && $this->checkFolder($originalDir,$this->diskOriginal)) {
                $return = $this->processDocument($tempFile,$uploadDir,$originalDir,$model, $this->format);
                @unlink($tempFile['storageFullPath']);
            } else {
                $return = false;
            }

            return $return;
        } catch (Exception $ex) {
            Log::error("Error Occured while document saving to FileSystem : " . $ex->getMessage());
            $return = false;
        };
    }

    public function fext($withOutDot = false)
    {
        return (($withOutDot) ? '' : '.') . $this->ext;
    }

    private function fullModelPath($targetDir,$modelid)
    {
        return $targetDir.DIRECTORY_SEPARATOR.$modelid;
    }

    private function processDocument($tempFile,$targetDir,$originalDir, $model, $format)
    {
        $config = $format;

        $tempFile['storageFullPath'];
        //Save Original File
        $ofn = $this->fullModelPath($originalDir,$model->uuid) . '-original' . $this->fext();
        $return = Storage::disk($this->disk)->put($ofn, \File::get($tempFile['storageFullPath']));

        $model->size = $this->documentInfo->getSize();
        $model->save();
        //Save Another copy to public and return it
        $fn = $this->fullModelPath($targetDir,$model->uuid) . $this->fext();
        $return = Storage::disk($this->disk)->put($fn, \File::get($tempFile['storageFullPath']));


        return $return;


    }

    private function previewDocument($tempFile,$format)
    {
        $config = $format;
        return null;

    }

    public function getPreview()
    {
        //Config Check
        if (!Config::get("upload.doc.uploadPath")) {
            Log::error("Upload Path Undefined");
            return false;
        }

        $image = $this->document;
        $format = $this->format;

        return null;
    }


}
