<?php
if (!function_exists('_languageAttribute')) {
    function _languageAttribute($attribute)
    {
        return $attribute . '_' . \LaravelLocalization::getCurrentLocale();
    }
}
if (!function_exists('_otherLangs')) {
    function _otherLangs()
    {
        return array_except(
            _getSupportedLanguagesAsArray(),
            _clang()
        );
    }
}
if (!function_exists('_clang')) {
    function _clang()
    {
        return strtolower(\LaravelLocalization::getCurrentLocale());
    }
}
if (!function_exists('_getSupportedLanguagesAsArray')) {
    function _getSupportedLanguagesAsArray()
    {
        $ret = [];
        foreach (\LaravelLocalization::getSupportedLocales() as $key => $locale) {
            $ret[$key] = $locale['name'];
        }
        return $ret;
    }
}
if (!function_exists('_getSupportedLanguageKeysAsArray')) {
    function _getSupportedLanguageKeysAsArray()
    {

        $ret = [];
        foreach (\LaravelLocalization::getSupportedLocales() as $key => $locale) {
            $ret[] = $key;
        }
        return $ret;

    }
}

if (!function_exists('_getFillableNameAttributes')) {
    function _getFillableNameAttributes()
    {
        return config('nette-lang.fillableModelFields', []);
    }
}

if (!function_exists('_getContentLanguageCode')) {
    function _getContentLanguageCode()
    {
        return str_replace('_', '-', config('laravellocalization.supportedLocales.' . _clang() . '.regional'));

    }
}

if (!function_exists('localizedAttributeName')) {
    function localizedAttributeName($fieldKey, $langKey = null)
    {
        $langKey = $langKey ?? config('app.locale');
        return $fieldKey . "_" . $langKey;
    }
}

if (!function_exists('langValue')) {

    function langValue($fileName, $key, $langCode, $b = '')
    {
        $value = Lang::get($fileName . '.' . $key, array(), $langCode);
        if ($value != $fileName . '.' . $key) {
            $b = $value;
        }
        return $b;
    }
}

if (!function_exists('langName')) {
    function langName($fileName, $key, $langCode, $b = '')
    {
        $value = str_replace('.', '][', preg_replace('/\.(.*?)\[/', '[\\1][', $key . '[' . $langCode . ']'));
        return $value;
    }
}

if (!function_exists('_e')) {
    function _e($value)
    { // Tek tırnak yok et
        $result = str_replace('\'', '&#039;', $value);
        return $result;
    }
}

if (!function_exists('isMultilingualActive')) {
    function isMultilingualActive()
    {
        return config('nette-lang.enable', false);
    }
}

if (!function_exists('_shareMultiSlugLocalizedUrls')) {
    function _shareMultiSlugLocalizedUrls($routename, $parameters = [])
    {
        $slugList = [];
        foreach (_getSupportedLanguageKeysAsArray() as $supportedLocale) {
            foreach ($parameters as $key => $parameter) {
                if (is_object($parameter)) {
                    $slugList[$supportedLocale]['parameters'][$key] = $parameter->{'slug_' . $supportedLocale};
                } elseif (is_array($parameter)) {
                    $slugList[$supportedLocale]['parameters'][$key] = $parameter['slug_' . $supportedLocale];
                }
            }

            $slugList[$supportedLocale]['route'] = $routename;
        }
        View::share('localizedSlugList', $slugList);
        return $slugList;
    }
}

if (!function_exists('_localizedCurrentUrl')) {
    function _localizedCurrentUrl($lang)
    {
        $localizedSlugList = View::shared('localizedSlugList');
        $routeParameters = Route::current() ? Route::current()->parameters() : [];
        $routeUrl = request()->url();
        $hideDefaultLocaleInURL = !config('laravellocalization.hideDefaultLocaleInURL', false);
        if (isset($localizedSlugList[$lang])) {
            if (isset($localizedSlugList[$lang]['parameters'])) {
                $routeParameters = $localizedSlugList[$lang]['parameters'];
            } else {
                $routeParameters = ['slug' => $localizedSlugList[$lang]['slug']];
            }
            $routeName = $localizedSlugList[$lang]['route'];
            $routeUrl = route($routeName, $routeParameters);
        }
        return LaravelLocalization::getLocalizedURL($lang, $routeUrl, $routeParameters, $hideDefaultLocaleInURL);
    }
}