<?php

namespace Nette\Multilingual\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App;

/**
 * #### Sets app locale from various variables  ####
 *
 * Respectively
 *
 * user_locale session -> user()->locale -> user_locale cookie
 *
 * @package App\Http\Middleware
 */
class SetLocale
{
    /**
     * Handle an incoming request and redirect to ssl.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */

    public function handle($request, Closure $next)
    {
        $targetLocale = config('app.locale');

        $user = Auth::guard(config('nette-lang.middleware_guard'))->user();

        if ($request->cookie('user_locale')){
            $targetLocale = $request->cookie('user_locale');
        } else {
            if ($request->session()->has('user_locale')) {
                $targetLocale = $request->session()->get('user_locale');
            } else if ($user) {
                $targetLocale = $user->locale ?? $targetLocale;
            } else {
                $requestedLang = $request->getPreferredLanguage(_getSupportedLanguageKeysAsArray());
                $targetLocale = $requestedLang;
            }
        }

        $request->session()->put('user_locale', $targetLocale);
        app()->setLocale($targetLocale);
        \LaravelLocalization::setLocale($targetLocale);
        return $next($request);
    }

}
