@extends('admin::_layouts.content',['selectedMenu'=>'settings'])

@section('content')

    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4>
                    <i class="icon-arrow-left52 mr-2"></i>
                    <span class="font-weight-semibold">Ayarlar</span> -Değiştir
                </h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        <form method="POST" action="{!! route('admin.settings.save') !!}" accept-charset="UTF-8" role="form"
              id="settingsSaveForm">
            @csrf
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header header-elements-inline">
                            <h6 class="card-title"><strong>Sistem Ayarları</strong></h6>
                        </div>

                        <div class="card-body">
                            <div class="d-md-flex">
                                <div class="col-sm-4 col-lg-3">
                                    <ul class="nav nav-tabs nav-tabs-vertical flex-column mr-md-3 mb-md-0 border-bottom-0">
                                        @foreach($settings as $key=>$setting)
                                            <li class="nav-item">
                                                <a aria-controls="pills-{{$key}}" aria-selected="true"
                                                   class="nav-link @if($key == 'main') active @endif" data-toggle="tab"
                                                   href="#settings-{{$key}}" id="settings-{{$key}}-tab"
                                                   role="tab">{{$tabs[$key]}}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                                <div class="col-sm-8 col-lg-9">
                                    <div class="tab-content" id="settings-tabContent">
                                        @foreach($settings as $tabKey=>$tab)
                                            <div class="tab-pane fade show @if($tabKey == 'main') active @endif"
                                                 id="settings-{{$tabKey}}" role="tabpanel">
                                                @foreach($tab as $settingKey => $setting)
                                                    <div class="f-group row">
                                                        <div class="col-sm-12 col-lg-2" style="padding-top:15px;">
                                                            <label class="f-label "
                                                                   for="{{$settingKey}}">{{$setting['name']}}:</label>
                                                        </div>
                                                        <div class="col-sm-12 col-lg-10">
                                                            @switch($setting['type'])
                                                                @case('text')
                                                                <input
                                                                    placeholder="{{$setting['name']}}"
                                                                    type="text"
                                                                    name="{{ 'settings['.$settingKey.']' }}"
                                                                    value="{{ (isset($data[$settingKey])?($data[$settingKey]??''):$setting['default']) }}"
                                                                    id="{{$settingKey}}"
                                                                />
                                                                @break
                                                                @case('textarea')
                                                                <textarea
                                                                    class="form-control"
                                                                    rows="3"
                                                                    placeholder="{{$setting['name']}}"
                                                                    name="{{ 'settings['.$settingKey.']' }}"
                                                                    id="{{$settingKey}}"
                                                                >{{ (isset($data[$settingKey])?($data[$settingKey]??''):$setting['default']) }}</textarea>
                                                                @break
                                                                @case('email')
                                                                <input
                                                                    class="form-control"
                                                                    placeholder="{{$setting['name']}}"
                                                                    type="email"
                                                                    name="{{ 'settings['.$settingKey.']' }}"
                                                                    value="{{ (isset($data[$settingKey])?($data[$settingKey]??''):$setting['default']) }}"
                                                                    id="{{$settingKey}}"
                                                                />
                                                                @break
                                                                @case('username')
                                                                <div class="input-group">
                                                                    <div class="input-group-prepend">
                                                                        <div class="input-group-text">
                                                                            @
                                                                        </div>
                                                                    </div>
                                                                    <input
                                                                        class="form-control"
                                                                        placeholder="{{$setting['name']}}"
                                                                        type="text"
                                                                        name="{{ 'settings['.$settingKey.']' }}"
                                                                        value="{{ (isset($data[$settingKey])?($data[$settingKey]??''):$setting['default']) }}"
                                                                        id="{{$settingKey}}"
                                                                    />
                                                                </div>
                                                                @break

                                                                @case('select')
                                                                <select class="form-control"
                                                                        name="{{ 'settings['.$settingKey.']' }}">
                                                                    @if(is_array($setting['options']))
                                                                        @foreach(($setting['options'] ?? []) as $optionKey => $option)
                                                                            <option value="{{$optionKey}}"
                                                                                    @if(($data[$settingKey]??'') == $optionKey) selected @endif>
                                                                                {{$option}}
                                                                            </option>
                                                                        @endforeach
                                                                    @else
                                                                        @if(isset(${$setting['options']}) && is_array(${$setting['options']}))
                                                                            @foreach((${$setting['options']} ?? []) as $optionKey => $option)
                                                                                <option value="{{$optionKey}}"
                                                                                        @if(($data[$settingKey]??'') == $optionKey) selected @endif>
                                                                                    {{$option}}
                                                                                </option>
                                                                            @endforeach
                                                                        @endif
                                                                    @endif
                                                                </select>
                                                                @break
                                                                @case('multiselect')
                                                                <select class="form-control" multiple="true"
                                                                        name="{{ 'settings['.$settingKey.'][]' }}">
                                                                    @foreach(($setting['options'] ?? []) as $optionKey => $option)
                                                                        <option value="{{$optionKey}}"
                                                                                @if(in_array($optionKey,($data[$settingKey]??[]))) selected @endif>
                                                                            {{$option}}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                @break
                                                                @case('date')
                                                                <input
                                                                    class="date"
                                                                    placeholder="{{$setting['name']}}"
                                                                    type="text"
                                                                    name="{{ 'settings['.$settingKey.']' }}"
                                                                    value="{{ (isset($data[$settingKey])?($data[$settingKey]??''):$setting['default']) }}"
                                                                    id="{{$settingKey}}"
                                                                />
                                                                @break
                                                                @case('radio')
                                                                <div class="f-group">
                                                                    @foreach(($setting['options'] ?? []) as $optionKey => $option)
                                                                        <div class="form-check">
                                                                            <label class="form-check-label">
                                                                                <input
                                                                                    class="form-check-input"
                                                                                    name="{{ 'settings['.$settingKey.']' }}"
                                                                                    type="radio"
                                                                                    value="{{$optionKey}}"
                                                                                    @if(($data[$settingKey]??'') == $optionKey) checked @endif
                                                                                /> {{$option}}</label>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                                @break
                                                                @case('checkbox')
                                                                <div class="f-bs-switch">
                                                                    <label class="">
                                                                        <input
                                                                            name="{{ 'settings['.$settingKey.']' }}"
                                                                            id="{{$settingKey}}"
                                                                            type="checkbox" class="bs-switch"
                                                                            value="1"
                                                                            data-on-text="Evet"
                                                                            data-off-text="Hayır"
                                                                            data-on-color="danger"
                                                                            data-off-color="default"
                                                                            @if(($data[$settingKey]??0) == 1) checked @endif
                                                                        >

                                                                    </label>
                                                                </div>

                                                                @break
                                                            @endswitch
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>

                                        @endforeach

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="f-save-bar">
                <div class="buttons">
                    <a href="{{ url()->previous() }}" class="btn btn-light legitRipple">Geri</a>
                    <button type="submit" class="btn bg-blue ml-3 legitRipple">Kaydet <i
                            class="icon-floppy-disk ml-2"></i></button>
                </div>
            </div>
        </form>

    </div>

@endsection
