<div class="card">
    <div class="card-header header-elements-inline">
        <h5 class="card-title">Meta Bilgileri</h5>
        <div class="header-elements">
            <div class="list-icons">
                <a class="list-icons-item" data-action="collapse"></a>
            </div>
        </div>
    </div>

    <div class="card-body">

        @if(config('nette-lang.enable'))
            <div class="tabbable">
                <ul class="nav nav-tabs nav-justified">
                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)
                        <li class="nav-item">
                            <a aria-controls="metalang_{{$key}}" aria-selected="true"
                               class="nav-link @if($key == LaravelLocalization::getCurrentLocale()) active @endif"
                               data-toggle="tab" href="#metalang_{{$key}}" id="metalang_{{$key}}-tab"
                               role="tab">{{ $lang['native'] }}</a>
                        </li>
                    @endforeach
                </ul>

                <div class="tab-content">
                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)

                        <div class="tab-pane{!! ($key==LaravelLocalization::getCurrentLocale()) ? ' active': null !!}"
                             id="metalang_{{$key}}">
                            <div class="f-group">
                                {!! html()->label('Title ('.$lang['native'].')')->for('meta['.$key.'][title]') !!}
                                {!! html()->text('meta['.$key.'][title]')->placeholder('Title ('.$lang['native'].')')->addClass('form-control'); !!}
                            </div>

                            <div class="f-group">
                                {!! html()->label('Description ('. $lang['native'] .')')->for('meta['.$key.'][description]') !!}
                                {!! html()->textarea('meta['.$key.'][description]')->placeholder('Description ('. $lang['native'] .')')->addClass('form-control'); !!}
                            </div>

                            <div class="f-group">
                                {!! html()->label('Meta ('. $lang['native'] .')')->for('meta['.$key.'][keywords]') !!}
                                {!! html()->textarea('meta['.$key.'][keywords]')->placeholder('Meta ('. $lang['native'] .')')->addClass('form-control') !!}
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @else
            <div class="f-group">
                {!! html()->label('Title')->for('meta[title]') !!}
                {!! html()->text('meta[title]')->placeholder('Title')->addClass('form-control'); !!}
            </div>

            <div class="f-group">
                {!! html()->label('Description')->for('meta[description]') !!}
                {!! html()->textarea('meta[description]')->placeholder('Description')->addClass('form-control') !!}
            </div>

            <div class="f-group">
                {!! html()->label('Keywords')->for('meta[keywords]') !!}
                {!! html()->textarea('meta[keywords]')->placeholder('Keywords')->addClass('form-control') !!}
            </div>

        @endif
    </div>
</div>
