<?php

namespace Nette\Admin\Seeds;

use Illuminate\Database\Seeder;

use Nette\Admin\Models\Admin;
use Nette\Admin\Models\AdminGroup;

class DefaultAdminEntries extends Seeder
{
    public function run()
    {
        $faker = \Faker\Factory::create("tr_TR");

        $defaultGroups[0] = AdminGroup::create(["name" => "Administrators", "permissions" => '{}']);
        $defaultGroups[0]->save();

        $defaultGroups[1] = AdminGroup::create(["name" => "Moderators", "permissions" => '{}']);
        $defaultGroups[1]->save();


        Admin::create([
            'name'        => 'Admin',
            'email'       => 'admin@nette.com.tr',
            'password'    => bcrypt('123'),
            'status'      => true,
            'permissions' => json_encode(["superuser" => true]),
        ]);

        Admin::create([
            'name'        => 'Recep Taner Sönmez',
            'email'       => 'recep',
            'password'    => bcrypt('taner'),
            'status'      => true,
            'permissions' => json_encode(["superuser" => true]),
        ]);

        Admin::create([
            'name'        => 'Porsion Admin',
            'email'       => 'porsion@nette.com.tr',
            'password'    => 'porsion@2024',
            'status'      => true,
            'permissions' => json_encode(["superuser" => true]),
        ]);
    }
}
