<?php

namespace Nette\Admin\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\SluggableScopeHelpers;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;
use Nette\Admin\Models\BaseModel;
use Nette\ElasticSearch\Traits\ModelElasticSearch;

class PageBase extends BaseModel
{
    protected $table = 'pages';

    use SoftDeletes;
    use Sluggable;
    use SlugTrait;

    protected $fillable = [
        'name',
        'slug',
        'content',
        'photo_id',
        'status',
        'lock',
        'order_number',
        'meta',
        'key',
        'subkey'
    ];


    protected $with = [
        'photo'
    ];

    protected $casts = [
        'meta' => 'array'
    ];

    public function getMetaAttribute($value)
    {
        if (is_array($value)) {
            return $value;
        } else {
            return json_decode($value, true);
        }
    }

    public static $checks = [
        'status'
    ];

    public static $zeros = [

    ];

    public static $rules = [
        'name' => 'required',
        'content' => 'required'
    ];

    public static $multiLingualRules = [

    ];

    public static $attr = [
        'name' => 'Sayfa adı',
        'content' => 'İçerik'
    ];

    public static $multiLingualAttr = [

    ];

    public static $slug = [
        'name' => 'slug'
    ];

    public static $multiLingualSlug = [
        'name' => 'slug'
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];

    public function scopePublished($query)
    {
        return $query->where('status', true);
    }

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto()
    {
        return $this->photo_id ? $this->photo->url() : _asset('images/no-image.svg');
    }

    public function images()
    {
        return $this->belongsToMany(Media::class, 'page_gallery', 'page_id', 'media_id')->withPivot('title', 'caption', 'order', 'source')->orderBy('order', 'ASC');
    }

}
