<?php

namespace Nette\Admin\Controllers;

use App\Packages\Category\Models\Category;
use Nette\Admin\Controllers\AdminBaseController as AdminBaseController;
use Illuminate\Http\Request;

use App\Http\Requests;

use File;
use Carbon\Carbon;
use Illuminate\Support\MessageBag;
use Redirect;

class SettingsController extends AdminBaseController
{

    public function __construct()
    {
        parent::__construct();
    }

    public function showSettings()
    {

        $errors = new MessageBag;

        if (!File::exists(base_path('settings.php'))) {
            $errors->add('filenotfound', 'Ayar Dosyası Bulunamadı. Kayıt işlemi çalışmayacak. Sistem Yöneticinize Başvurun');
        } else if (!File::isWritable(base_path('settings.php'))) {
            $errors->add('filenotwritable', 'Ayar Dosyası İzinlerinde problem var. Kayıt işlemi çalışmayacak. Sistem Yöneticinize Başvurun');
        }
        $settings = config('settings');

        //Tab Name tabanlı sıralama
        $section = [];
        foreach ($settings["fields"] as $key => $row) {
            if(isset($row['helper'])){
                if(function_exists($row['helper'])){
                    $row['options'] = $row['helper']();
                }
            }

            $section[$row['tab']][$key] = $row;
        }
        //dd($section);

        $data = [];
        if (File::exists(base_path('settings.php'))) {
            $data = include base_path('settings.php');
        }


        return view('admin::settings')
            ->with('settings', $section)
            ->with('tabs', $settings["tabs"])
            ->with('data', $data)
            ->with('errors', $errors);

    }

    /**
     * Saves data & generate new php config file with data from coming show()
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveSettings(Request $request)
    {
        $settings = $request->settings;

        //TODO: Type Checks and change defaults;

        $fileContent = "<?php\n\nreturn ";
        $fileContent .= var_export($settings, true);
        $fileContent .= ';';

        //dd($settings);

        $isFileExist = File::exists(base_path('settings.php'));
        if (!$isFileExist) {
            $fileContent .= "\n\t// file_created_at: " . Carbon::now() . "\n\n";
        } else {
            $fileContent .= "\n\t// file_updated_at: " . Carbon::now() . "\n\n";
        }

        $obj = File::put(base_path('settings.php'), $fileContent);
        //ASYNC HACK
        sleep(3);
        if ($obj) {
            $request->session()->flash('success', 'Ayarlar başarıyla kaydedildi!');
        }

        return redirect()->route('admin.settings.index');
    }
}
