<?php

namespace Nette\Admin\Controllers;

use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use Nette\Admin\Models\Page;
use UploadManager;

use Nette\Admin\Requests\Page\Request as PageRequest;

class PageController extends AdminBaseController
{
    public $cTitle = 'Sayfalar';
    public $cMenuKey = 'page';

    public $cBreadcrumb = [
        'name' => 'Sayfalar',
        'route' => 'admin.page.index',
    ];

    public $cModel = Page::class;
    public $cModelName = 'Sayfa';

    public $cKey = 'page';

    public $cBladeKey = null;

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.page.index';
    public $cIndexTitle = 'Liste';

    public $cShow = true;
    public $cShowRoute = 'admin.page.show';
    public $cShowTitle = 'Görüntüle';
    public $cShowBlade = null;
    public $cShowPermission = 'page.view';


    public $cCreate = true;
    public $cCreateBlade = 'admin::page.create';
    public $cCreateRoute = 'admin.page.create';
    public $cCreateTitle = 'Yeni ';
    public $cCreateMethodRoute = 'admin.page.store';
    public $cCreatePermission = 'page.create';

    public $cEdit = true;
    public $cEditRoute = 'admin.page.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.page.update';
    public $cEditPermission = 'page.edit';

    public $cPublish = true;
    public $cPublishRoute = 'admin.page.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'page.publish';

    public $cDelete = true;
    public $cDeleteRoute = 'admin.page.destroy';
    public $cDeletePermission = 'page.delete';

    public $cBatchDelete = true;
    public $cBatchDeleteRoute = 'admin.page.batchdestroy';

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.page.orderable';

    public $cSortable = false;
    public $cSortableColumn = 'order_number';


    public $cOrderMediaRoute = 'admin.page.ordermedia';
    public $cUpdateMediaRoute = 'admin.page.updatemedia';
    public $cDeleteMediaRoute = 'admin.page.deletemedia';


    public $cFields = [
        'id' => ['name' => 'ID', 'sortable' => true,'size'=>'mini'],
        'name' => ['name' => 'Sayfa Adı'],
        'key' => ['name' => 'Anahtar','size'=>'medium'],
        'subkey' => ['name' => 'Üst Anahtar','size'=>'medium'],
        'lock' => ['name' => 'Kilitli','size'=>'mini'],
    ];

    public $cFieldMutators = [
        'lock' => 'isLocked',
    ];

    public $cFilterable = true;
    public $filters = [
        'field' => [
            'name' => 'Sayfa Adı',
            'type' => 'text',
            'operator' => 'like'
        ],
    ];


    public $cModuleFiles = [
        [
            'name' => 'Sayfa resmi',
            'type' => 'img',
            'key' => 'page',
            'database_key' => 'photo_id',
            'multiple' => false,
            'attach_func' => 'photo'
        ],
        [
            'name' => 'Sayfa Galerisi',
            'type' => 'img',
            'key' => 'page_gallery',
            'multiple' => true,
            'attach_func' => 'images'
        ],

    ];

    public $cSidebarModules = [
        'admin::_partials.sidebar.elements.page'
    ];

    public function __construct()
    {
        parent::__construct();
    }


    public function store(PageRequest $request)
    {
        return parent::_store($request);
    }

    public function update(PageRequest $request, $id)
    {
        return parent::_update($request, $id);
    }



}
