<?php

namespace Nette\Admin\Controllers;

use Carbon\Carbon;
use Nette\Admin\Controllers\AdminBaseController as AdminBaseController;
use Illuminate\Http\Request;
use Cache;
use Analytics;
use Spatie\Analytics\Period;

class AnalyticsController extends AdminBaseController
{

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function userTypes(Request $request){
        if($request->ajax()) {
            $analyticsData = Analytics::fetchUserTypes(Period::days(1));
            if($analyticsData){
                return response()->json(['status' => 'success','data' => $analyticsData]);
            }
        }
        return response()->json(['status','fail','message' => 'Somethings wrong']);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function referralData(Request $request){
        if($request->ajax()) {
            $analyticsData = Analytics::fetchTopReferrers(Period::days(1), 12);
            if($analyticsData){
                return response()->json(['status' => 'success','data' => $analyticsData]);
            }
        }
        return response()->json(['status','fail','message' => 'Somethings wrong']);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function geoVisitors(Request $request){
        if($request->ajax()) {
            $analyticsData = Analytics::performQuery(Period::days(11), 'ga:sessions', [
                'metrics' => 'ga:users',
                'dimensions' => 'ga:country'
            ]);

            if($analyticsData){

                $geoData = [];
                foreach ($analyticsData->rows as $row) {
                    $geoData[] = [
                        $row[0],$row[1]
                    ];
                }

                return response()->json(['status' => 'success','data' => $geoData]);
            }
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function socialMedia(Request $request){
        if($request->ajax()){

            $analyticsDataToday = Analytics::performQuery(Period::create(Carbon::today(),Carbon::today()->addHours(23)->addMinutes(59)->addSeconds(59)),'ga:sessions',[
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:socialNetwork'
            ]);

            $analyticsDataYesterday = Analytics::performQuery(Period::create(Carbon::yesterday(),Carbon::yesterday()->addHours(23)->addMinutes(59)->addSeconds(59)),'ga:sessions',[
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:socialNetwork'
            ]);

            return response()->json(['status' => 'success','data' => ['today' => $analyticsDataToday->rows,'yesterday' => $analyticsDataYesterday->rows]]);

        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function searchKeyword(Request $request){
        if($request->ajax()){

            $analyticsData = Analytics::performQuery(Period::days(1),'ga:sessions',[
                'metrics' => 'ga:sessions',
                'dimensions' => 'ga:keyword',
                'max-results' => 6
            ]);

            if($analyticsData){
                return response()->json(['status' => 'success','data' => $analyticsData->rows]);
            }

            return response()->json(['status','fail','message' => 'Somethings wrong']);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function analyticsData(Request $request){
        if($request->ajax()){
            $analyticsData = Analytics::fetchTotalVisitorsAndPageViews(Period::days(7));
            if($analyticsData){
                $data = [];
                $data['views'][] = 'Sayfa Görünümleri';
                $data['visitors'][] = 'Yeni Ziyaretçi';
                foreach ($analyticsData as $analyticsDatum) {
                    $data['categories'][] = $analyticsDatum['date']->format("l");
                    $data['views'][] = $analyticsDatum['pageViews'];
                    $data['visitors'][] = $analyticsDatum['visitors'];
                }
                return response()->json(['status' => 'success','data' => $data]);
            }

            return response()->json(['status','fail','message' => 'Somethings wrong']);
        }

    }

}
