<?php

namespace Nette\Admin\Controllers;


use ModuleLoader;
use Validator;

use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use Nette\Admin\Models\Admin;
use Nette\Admin\Models\AdminGroup;
use Nette\Admin\Requests\AdminGroups\Request as AdminGroupsRequest;
use Str;

class AdminGroupsController extends AdminBaseController
{

    public function __construct()
    {
        parent::__construct();

    }


    public function index()
    {
        $column     = request()->get('order_field', 'id');
        $direction  = request()->get('order_dir', 'asc');

        $admingroups = AdminGroup::orderBy($column, $direction)->with('Admins')->paginate(_config('item_per_page'));
        return view('admin::admingroups.index')
            ->with('items', $admingroups)
            ->with('orderBy', ['column' => $column, 'direction' => $direction]);
    }

    public function create()
    {

        $modules = ModuleLoader::getModuleData();
        $permissionData = ModuleLoader::getPermissionSet();

        $permissionGrid = [];
        foreach ($modules as $key => $module){
            foreach (($module['permissions'] ?? []) as $permissionKey => $permission){
                $permissionGrid[$permissionKey] = false;
            }

        }

        return view('admin::admingroups.create')
            ->with('method', 'POST')
            ->with('methodURL', route('admin.admingroups.store'))
            ->with('modules', $modules)
            ->with('permissionData', $permissionData)
            ->with('permissionGrid', $permissionGrid);
    }

    public function store(AdminGroupsRequest $request)
    {
        $input = $request->all();

        $gridInputs = $request->except(['_token', 'name', 'save','_method']);
        $grid = [];
        foreach ($gridInputs as $key => $val) {
            //Replace Last occurence of "."
            $proccessedKey = Str::replaceLast('_', '.', $key);
            $grid[$proccessedKey] = $val;
        }

        $permissionJson = json_encode($grid, JSON_FORCE_OBJECT);
        $input["permissions"] = $permissionJson;

        $obj = AdminGroup::create($input);
        if ($obj->save()) {
            $request->session()->flash('success', 'Yönetici Grubu Başarıyla Oluşturuldu');
        }

        return redirect()->route('admin.admingroups.index');
    }


    public function edit($id)
    {

        $modules = ModuleLoader::getModuleData();
        $permissionData = ModuleLoader::getPermissionSet();

        $group = AdminGroup::findOrFail($id);

        $groupPermissions = json_decode($group->permissions);


        $permissionGrid = [];
        foreach ($modules as $key => $module){
            foreach (($module['permissions'] ?? []) as $permissionKey => $permission){
                $permissionGrid[$permissionKey] = property_exists($groupPermissions, $permissionKey) ? $groupPermissions->$permissionKey : false;
            }
        }


        return view('admin::admingroups.create')
            ->with('method', 'PUT')
            ->with('methodURL', route('admin.admingroups.update',['id'=>$id]))
            ->with('item', $group)
            ->with('modules', $modules)
            ->with('permissionData', $permissionData)
            ->with('permissionGrid', $permissionGrid);

    }


    public function update(AdminGroupsRequest $request, $id)
    {

        $input = $request->all();
        $obj = AdminGroup::findOrFail($id);

        $gridInputs = $request->except(['_token', 'name', 'save','_method']);
        $grid = [];
        foreach ($gridInputs as $key => $val) {
            //Replace Last occurence of "."
            $proccessedKey = str_replace_last('_', '.', $key);
            $grid[$proccessedKey] = $val;
        }

        $permissionJson = json_encode($grid, JSON_FORCE_OBJECT);
        $input["permissions"] = $permissionJson;

        if ($obj->update($input)) {
            $request->session()->flash('success', 'Yönetici Grubu Başarıyla Düzenlendi');
        }

        return redirect()->route('admin.admingroups.index');

    }

    public function destroy(Request $request, $id)
    {
        $result = result(false);
        $item = AdminGroup::findOrFail($id);
        if (!$item->delete()) {
            $result = result(false);
        } else {
            $result = result(true);
        }
        return response()->json($result);
    }

}
