<?php

namespace Nette\Admin\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

use FilterGenerator;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use UploadManager;

class AdminBaseController extends BaseController
{

    public $cTitle = null;

    public $cMenuKey = null;

    public $cBreadcrumb = [
        'name' => null,
        'route' => null,
    ];

    public $cModel = null;
    public $cModelName = null;

    public $cKey = null;

    //DEFAULT BLADE key
    public $cBladeKey = null;

    //region Index Settings
    public $cIndexBlade = null;
    public $cIndexRoute = null;
    public $cIndexTitle = null;
    public $cIndexPermission = null;
    //işlemler sütununu gizle/goster
    public $cIndexActions = true;
    //endregion

    //region Show Settings
    public $cShow = null;
    public $cShowRoute = null;
    public $cShowTitle = null;
    public $cShowPermission = null;
    public $cShowBlade = null;
    //endregion

    //region Create Settings
    public $cCreate = null;
    public $cCreateRoute = null;
    public $cCreateTitle = null;
    public $cCreateMethodRoute = null;
    public $cCreatePermission = null;
    public $cCreateBlade = null;
    //endregion

    //region Edit Settings
    public $cEdit = null;
    public $cEditRoute = null;
    public $cEditTitle = null;
    public $cEditMethodRoute = null;
    public $cEditPermission = null;
    //endregion

    //region Publish Settings
    public $cPublish = null;
    public $cPublishRoute = null;
    public $cPublishTitle = null;
    public $cPublishPermission = null;
    //endregion

    //region Delete Settings
    public $cDelete = null;
    public $cDeleteRoute = null;
    public $cDeleteTitle = null;
    public $cDeletePermission = null;
    //endregion

    //region Batch Delete Settings
    public $cBatchDelete = null;
    public $cBatchDeleteRoute = null;
    //endregion

    //region Orderable Settings
    public $cOrderable = null;
    public $cOrderableColumn = 'order_id';
    public $cOrderableRoute = null;
    //endregion

    //region Sortable Settings

    public $cSortable = null;
    public $cSortableColumn = 'order_id';
    public $cSortableRoute = null;
    //endregion

    public $cOrderMediaRoute = null;
    public $cUpdateMediaRoute = null;
    public $cDeleteMediaRoute = null;

    //FILTERABLE
    public $cFilterable = null;

    public $cTaggable = null;
    public $cTaggableRoute = null;
    public $cTagInputName = 'tags';
    public $cTagFunction = 'tags';
    public $cTagModel = null;

    //FIELDS
    public $cFields = [
        'id' => ['name' => 'ID'],
        'name' => ['name' => 'İsim']
    ];

    public $cFieldMutators = [
    ];

    public $cRelations = [
    ];

    public $filters = [
    ];

    public $cModuleFiles = [];

    public $cSidebarModules = [];
    public $cLayoutModules = [];
    public $cCSSModules = [];
    public $cJSModules = [];


    public $cCustomPermissions = [];

    public $defaultIndexOrder = 'asc';

    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function __construct()
    {

        if (isset($this->filters)) {
            view()->share('filterable', true);
            view()->share('allFilters', $this->filters);
        }

        view()->share([
            'cTitle' => $this->cTitle,

            'cMenuKey' => $this->cMenuKey,

            'cBreadcrumb' => $this->cBreadcrumb,

            'cKey' => $this->cKey,
//
            'cModel' => $this->cModel,
            'cFields' => $this->cFields,
            'cFieldMutators' => $this->cFieldMutators,

            'cIndexBlade' => $this->cIndexBlade,
            'cIndexRoute' => $this->cIndexRoute,
            'cIndexTitle' => $this->cIndexTitle,
            'cIndexPermission' => $this->cIndexPermission,
            'cIndexActions' => $this->cIndexActions,

            'cShow' => $this->cShow,
            'cShowBlade' => $this->cShowBlade,
            'cShowRoute' => $this->cShowRoute,
            'cShowTitle' => $this->cShowTitle,
            'cShowPermission' => $this->cShowPermission,

            'cCreate' => $this->cCreate,
            'cCreateBlade' => $this->cCreateBlade,
            'cCreateRoute' => $this->cCreateRoute,
            'cCreateTitle' => $this->cCreateTitle,
            'cCreateMethodRoute' => $this->cCreateMethodRoute,
            'cCreatePermission' => $this->cCreatePermission,

            'cEdit' => $this->cEdit,
            'cEditRoute' => $this->cEditRoute,
            'cEditTitle' => $this->cEditTitle,
            'cEditMethodRoute' => $this->cEditMethodRoute,
            'cEditPermission' => $this->cEditPermission,


            'cPublish' => $this->cPublish,
            'cPublishRoute' => $this->cPublishRoute,
            'cPublishTitle' => $this->cPublishTitle,
            'cPublishPermission' => $this->cPublishPermission,

            'cDelete' => $this->cDelete,
            'cDeleteRoute' => $this->cDeleteRoute,
            'cDeletePermission' => $this->cDeletePermission,


            'cBatchDelete' => $this->cBatchDelete,
            'cBatchDeleteRoute' => $this->cBatchDeleteRoute,

            'cOrderable' => $this->cOrderable,
            'cOrderableColumn' => $this->cOrderableColumn,
            'cOrderableRoute' => $this->cOrderableRoute,

            'cSortable' => $this->cSortable,
            'cSortableColumn' => $this->cSortableColumn,
            'cSortableRoute' => $this->cSortableRoute,

            'cOrderMediaRoute' => $this->cOrderMediaRoute,
            'cUpdateMediaRoute' => $this->cUpdateMediaRoute,
            'cDeleteMediaRoute' => $this->cDeleteMediaRoute,

            'cFilterable' => $this->cFilterable,
            'cFilters' => $this->filters,

            'cTaggable' => $this->cTaggable,
            'cTaggableRoute' => $this->cTaggableRoute,
            'cTagInputName' => $this->cTagInputName,
            'cTagFunction' => $this->cTagFunction,
            'cTagModel' => $this->cTagModel,

            'cModuleFiles' => $this->cModuleFiles,

            'cSidebarModules' => $this->cSidebarModules,
            'cLayoutModules' => $this->cLayoutModules,
            'cCSSModules' => $this->cCSSModules,
            'cJSModules' => $this->cJSModules,

            'cCustomPermissions' => $this->cCustomPermissions,


        ]);

    }

    public function index()
    {
        $this->check('cIndexPermission');
        $column = request()->get('order_field', 'id');
        $direction = request()->get('order_dir', $this->defaultIndexOrder);

        //Multilang attribute alanlarında orderBy çalışmadığı için yerine sortBy ve SortByDesc kullanıldı.
        /* if($direction != 'asc') {
             $lists = $this->moduleModel::sortByDesc($column);
         }else{
             $lists = $this->moduleModel::sortBy($column);
         }*/
        $items = $this->cModel::orderBy($column, $direction);
        if ($this->cFilterable) {
            $items = FilterGenerator::apply($this->filters, $items);
        }
        $items = $items->paginate(_config('admin.rows', 500));


        return view($this->blade('index'))
            ->with('items', $items);

    }


    public function show($id)
    {
        $this->check('cShowPermission');
        if (!$id) {
            abort(404);
        }

        $item = $this->cModel::findOrFail($id);

        return view($this->blade('show'))
            ->with('item', $item);
    }

    public function create()
    {
        $this->check('cCreatePermission');
        return view($this->blade('create'))
            ->with('method', 'POST')
            ->with('methodURL', route($this->cCreateMethodRoute));
    }

    public function edit($id)
    {
        $this->check('cEditPermission');
        if (!$id) {
            abort(404);
        }

        $item = $this->cModel::findOrFail($id);


        return view($this->cCreateBlade)
            ->with('item', $item)
            ->with('method', 'PUT')
            ->with('methodURL', route($this->cEditMethodRoute, ['id' => $id]));
    }

    public function _store($request, $return = false)
    {
        $saveObj = $this->save($request, null, $return);
        if ($saveObj) {
            if ($return) {
                return $saveObj;
            }
            $request->session()->flash('success', 'Kayıt işlemi başarılı!');
            return back()->withInput();
        }
        return back()->withInput();
    }

    public function _update($request, $id, $return = false)
    {
        $saveObj = $this->save($request, $id, $return);
        if ($saveObj) {

            if ($return) {
                return $saveObj;
            }
            $request->session()->flash('success', 'Güncelleme işlemi başarılı!');
            return back()->withInput();
        }
        return back()->withInput();
    }

    private function save($request, $id = null, $return = false)
    {
        $input = $request->all();
        $obj = null;

        if (count($this->cModuleFiles) > 0) {
            UploadManager::set(request()->_skey);

            if (array_search(false, array_column($this->cModuleFiles, 'multiple')) !== false) {
                foreach ($this->cModuleFiles as $moduleFile) {
                    if ($moduleFile['multiple'] === false) {
                        $uploadItem = UploadManager::save($moduleFile['type'] ?? 'img', $moduleFile['key'] ?? 'page');
                        if ($uploadItem !== false) {
                            if ($uploadItem !== null) {
                                $input[$moduleFile['database_key']] = $uploadItem->id;
                            } else {
                                $input[$moduleFile['database_key']] = null;
                            }
                        }
                    }
                }
            }
        }

        if (isset($id)) {
            $obj = $this->cModel::findOrFail($id);
            $obj->update($input);
        } else {
            $obj = $this->cModel::create($input);
        }

        if (isset($id)) {
            activity()->performedOn($obj)->withProperties(['ip' => request()->ip()])->log('edit');
        } else {
            activity()->performedOn($obj)->withProperties(['ip' => request()->ip()])->log('create');
        }

        if (isset($id)) {
            if (getFillable($this->cModel, 'edit_author')) {
                $obj->edit_author = admin()->id;
            }
        } else {
            if (getFillable($this->cModel, 'author')) {
                $obj->author = admin()->id;
            }
        }


        if ($obj->save()) {
            if (count($this->cModuleFiles) > 0) {
                if (array_search(true, array_column($this->cModuleFiles, 'multiple')) !== false) {
                    foreach ($this->cModuleFiles as $moduleFile) {
                        if ($moduleFile['multiple'] === true) {
                            $hasItem = UploadManager::hasItem($moduleFile['type'] ?? 'img', $moduleFile['key'] ?? 'page');
                            if ($hasItem) {
                                $galleryItems = UploadManager::save($moduleFile['type'] ?? 'img', $moduleFile['key'] ?? 'page');
                                if ($galleryItems !== false) {
                                    if ($galleryItems !== null && count($galleryItems) > 0) {
                                        $count = $obj->{$moduleFile['attach_func']}()->count();
                                        foreach ($galleryItems as $galleryItem) {
                                            $obj->{$moduleFile['attach_func']}()->attach($galleryItem->id, ['order' => $count + 1]);
                                            $count++;
                                        }
                                    } else {
                                        $obj->{$moduleFile['attach_func']}()->detach();
                                    }

                                }
                            }
                        }
                    }
                }
            }

            if ($this->cTaggable) {
                $obj->{$this->cTagFunction}()->detach();
                if (isset($input[$this->cTagInputName])) {
                    foreach (($input[$this->cTagInputName] ?? []) as $key => $value) {
                        if (is_numeric($value)) {
                            $tag = $this->cTagModel::find($value);
                            if ($tag) {
                                $obj->{$this->cTagFunction}()->attach($tag);
                            }
                        } else {
                            $tag = $this->cTagModel::firstOrCreate(["name" => $value]);
                            $obj->{$this->cTagFunction}()->attach($tag);
                        }
                    }
                }
            }
            //Async Module Fİles & Tags requires a touch for elasticsearch.
            $obj->touch();

            return $return ? $obj : true;
        }

        return false;
    }

    public function publish(Request $request, $id)
    {
        $this->check('cPublishPermission');
        if (!$id) {
            abort(404);
        }

        $result = result(false);
        $input = $request->all();
        $item = $this->cModel::findOrFail($id);
        $itemStatus = (bool)$item->status;

        $item->status = !$itemStatus;

        if (!$item->save()) {
            $result = result(false, 'failed');
        } else {
            $result = result(true, $item->status ? 'published' : 'unpublished');
        }

        activity()->performedOn($item)->withProperties(['ip' => request()->ip(), 'status' => $item->status])->log('change_status');
        return response()->json($result);

    }

    public function destroy(Request $request, $id)
    {
        $result = result(false);

        $this->check('cDeletePermission');

        $item = $this->cModel::findOrFail($id);
        if ($item->lock) {
            $result = result(false);
        } else {
            if (!$item->delete()) {
                $result = result(false);
            } else {
                activity()->withProperties(['ip' => request()->ip(), 'model' => $this->cModel, 'id' => $id])->log('destroy');
                $result = result(true);
            }
        }
        return response()->json($result);
    }

    public function batchDestroy(Request $request)
    {
        $result = result(false);

        $this->check('cDeletePermission');

        $deleteItems = $request->items;
        //TODO::elasticte bach destroy calismiyor guncellemiyor gecici cozum olarak uygulandi!!!!
        foreach ($deleteItems as $deleteItem) {
            $item = $this->cModel::where('id', $deleteItem);
            if (getFillable($this->cModel, 'lock')) {
                $item = $item->where('lock', false);
            }
            $item = $item->first();
            if ($item) {
                $item->delete();
            }
        }

//        if (getFillable($this->cModel, 'lock')) {
//            $items = $this->cModel::where('lock', false)->whereIn('id', $deleteItems);
//        } else {
//            $items = $this->cModel::whereIn('id', $deleteItems);
//        }
//        if (!$items->delete()) {
//            $result = result(false);
//        } else {
        $result = result(true);
        activity()->withProperties(['ip' => request()->ip(), 'model' => $this->cModel, 'items' => $deleteItems])->log('batch_destroy');
//        }
        return response()->json($result);
    }

    public
    function orderable(Request $request)
    {
        $this->check('cEditPermission');

        $input = $request->all();

        foreach ($input['order_number'] as $id => $value) {
            $row = $this->cModel::find($id);
            $row->order_number = $value;
            $row->save();
        }

        activity()->withProperties(['ip' => request()->ip(), 'model' => $this->cModel, 'order' => $input['order_number']])->log('change_order');
        return redirect(url()->previous())->with('success', 'Sıralama başarıyla güncellendi.');
    }

    public
    function updateMedia(Request $request, $id)
    {
        $this->check('cEditPermission');

        $currentAttachFunction = $request->func ?? 'multi';

        $galleryItem = $this->cModel::findOrFail($id);

        if ($request->mediaId == null || !is_numeric($request->mediaId)) {
            return response()->json(result(false));
        } else {
            $galleryItem->{$currentAttachFunction}()->updateExistingPivot($request->mediaId, ['title' => $request->title, 'caption' => $request->caption, 'source' => $request->source]);
            $galleryItem->touch();
            activity()->performedOn($galleryItem)->withProperties(['ip' => request()->ip(), 'model' => $this->cModel, 'media_id' => $request->mediaId])->log('updated_gallery_item');
            return response()->json(result(true));
        }

        return response()->json(result(false));
    }

    public
    function deleteMedia(Request $request, $id)
    {
        $this->check('cEditPermission');

        $currentAttachFunction = $request->func ?? 'multi';

        $galleryItem = $this->cModel::with(['photo', $currentAttachFunction])->findOrFail($id);

        if ($request->mediaId == null || !is_numeric($request->mediaId)) {
            return response()->json(result(false));
        } else {

            $galleryItem->{$currentAttachFunction}()->detach($request->mediaId);
            activity()->performedOn($galleryItem)->withProperties(['ip' => request()->ip(), 'model' => $this->cModel, 'media_id' => $request->mediaId])->log('deleted_gallery_item');

            return deleteMedia($request->mediaId);
        }

        $galleryItem->touch();
        return response()->json(result(false));
    }

    public
    function orderMedia(Request $request, $id)
    {
        $this->check('cEditPermission');

        $currentAttachFunction = $request->func ?? 'multi';

        $order = json_decode($request->order ?? '[]', TRUE);

        $galleryItem = $this->cModel::with(['photo', $currentAttachFunction])->findOrFail($id);

        $projectImageCaptions = $galleryItem->{$currentAttachFunction}->pluck('pivot.caption', 'id')->toArray();
        $projectImageTitles = $galleryItem->{$currentAttachFunction}->pluck('pivot.title', 'id')->toArray();
        $projectImageSources = $galleryItem->{$currentAttachFunction}->pluck('pivot.source', 'id')->toArray();

        if ($order && count($order) > 0) {
            $galleryItem->{$currentAttachFunction}()->detach();

            foreach ($order as $imageKey => $orderNumber) {
                $galleryItem->{$currentAttachFunction}()->attach($imageKey, [
                    'title' => ($projectImageTitles[$imageKey] != "") ? $projectImageTitles[$imageKey] : null,
                    'caption' => ($projectImageCaptions[$imageKey] != "") ? $projectImageCaptions[$imageKey] : null,
                    'source' => ($projectImageSources[$imageKey] != "") ? $projectImageSources[$imageKey] : null,
                    'order' => (int)$orderNumber
                ]);
            }

            $galleryItem->touch();
            activity()->performedOn($galleryItem)->withProperties(['ip' => request()->ip(), 'model' => $this->cModel])->log('ordered_media_item');

            return response()->json(result(true));

        }


        returnresponse()->json(result(false));
    }

    public
    function tags()
    {
        $query = request()->q ?? null;

        $query['term'] = $query['term'] ?? '';

        $resultList = $this->cTagModel::where('name', 'LIKE', "{$query['term']}%")
            ->orWhere('name', 'LIKE', "%{$query['term']}%")
            ->select([DB::raw('name as text'), 'id'])
            ->get()
            ->toArray();

        return response()->json($resultList);

    }

    public
    function check($permission)
    {
        if ($this->{$permission} && !checkPermission($this->{$permission})) {
            return abort(403);
        }
    }

    public
    function checkFromString($permission)
    {
        if (!checkPermission($permission)) {
            return abort(403);
        }
    }

    public
    function blade($type)
    {
        $return = 'admin::';
        switch ($type) {
            case 'index':
                $return = $this->cIndexBlade ?? ($return . ($this->cBladeKey ?? 'default') . '.' . 'index');
                break;
            case 'show':
                $return = $this->cShowBlade ?? ($return . ($this->cBladeKey ?? 'default') . '.' . 'show');
                break;
            case 'create':
                $return = $this->cCreateBlade ?? ($return . ($this->cBladeKey ?? 'default') . '.' . 'create');
                break;
            case 'edit':
                $return = $this->cCreateBlade ?? ($return . ($this->cBladeKey ?? 'default') . '.' . 'create');
                break;
            default:
                $return = $return . ($this->cBladeKey ?? 'default') . '.' . 'index';
                break;
        }

        return $return;
    }


}
