<title><?php echo e((isset($pageTitle))?$pageTitle:trans('meta.title')); ?></title>
<meta name="csrf-token" content="<?php echo csrf_token(); ?>"/>
<meta name="theme-color" content="#ffffff"/>
<meta name="msapplication-navbutton-color" content="#ffffff">
<meta name="apple-mobile-web-app-status-bar-style" content="#ffffff">

<?php if($current_menu == 'home'): ?>
    <meta name="description" content="<?php echo _config('site_description'); ?>"/>
<?php else: ?>
    <meta name="description" content="<?php echo isset($pageDescription) ? $pageDescription: _config('site_description'); ?>"/>
<?php endif; ?>

<meta name="author" content="<?php echo e(_config('site_author','')); ?>"/>
<meta property="og:site_name" content="<?php echo e(_config('site_name')); ?>"/>
<meta property="og:url" content="<?php echo e((isset($pageUrl))?$pageUrl:Request::url()); ?>"/>
<meta property="description" content="<?php echo e(isset($pageDescription) ? $pageDescription: _config('site_description')); ?>"/>
<meta property="og:type" content="<?php echo e((isset($pageType_og))?$pageType_og:'article'); ?>"/>
<meta property="og:title" content="<?php echo e((isset($pageTitle))?$pageTitle:_config("site_name")); ?>"/>
<meta property="og:description" content="<?php echo e(isset($pageDescription) ? $pageDescription: trans('meta.description')); ?>"/>
<meta property="og:image" content="<?php echo isset($pageImage) ? $pageImage: _asset('images/logo.png'); ?>"/>

<meta name="image" itemprop="image" content="<?php echo isset($pageImage) ? $pageImage: _asset('images/logo.png'); ?>"/>
<?php if(isset($pageThumbnail)): ?>
    <meta name="thumbnail" itemprop="thumbnailUrl"
          content="<?php echo $pageThumbnail ? $pageThumbnail :  _asset('images/logo.png'); ?>"/>
<?php endif; ?>

<meta property="twitter:site" content="<?php echo e(_config('twitter_handle')); ?>"/>
<meta property="twitter:creator" content="<?php echo e(_config('twitter_handle')); ?>"/>
<meta property="twitter:card" content="<?php echo e((isset($pageType_twitter))?$pageType_twitter:'summary'); ?>"/>
<meta property="twitter:url" content="<?php echo e((isset($pageUrl))?$pageUrl:Request::url()); ?>"/>
<meta property="twitter:domain" content="<?php echo e((isset($pageDomain))?$pageDomain:config('app.url')); ?>"/>
<meta property="twitter:title" content=" <?php echo e((isset($pageTitle))?$pageTitle:_config("site_name")); ?>"/>
<meta property="twitter:description" content="<?php echo e(isset($pageDescription) ? $pageDescription: _config("site_name")); ?>"/>
<meta property="twitter:image" content="<?php echo e(isset($pageImage) ? $pageImage: asset('assets/images/logo.png')); ?>"/>

<?php if(_clang() == "tr"): ?>
    <meta http-equiv="content-language" content="tr-TR"/>
    <meta itemprop="inLanguage" content="tr"/>
<?php elseif(_clang() == "en"): ?>
    <meta http-equiv="content-language" content="en-US"/>
    <meta itemprop="inLanguage" content="en"/>
<?php else: ?>
    <meta http-equiv="content-language" content="ru-RU"/>
    <meta itemprop="inLanguage" content="ru"/>
<?php endif; ?>

<?php if(!isset($metaRobots)): ?>
    <?php if((env('APP_ENV') == 'local') || (env('APP_ENV') == 'testing')): ?>
        <meta name="robots" content="noindex nofollow">
    <?php else: ?>
        <meta name="robots" content="index follow">
    <?php endif; ?>
<?php else: ?>
    <meta name="robots" content="<?php echo $metaRobots; ?>">
<?php endif; ?>
<?php if(isset($isNews)): ?>
    <meta name="genre" itemprop="genre" content="News"/>
    <meta itemprop="isFamilyFriendly" content="True"/>
<?php endif; ?>
<meta name="url" itemprop="url" content="<?php echo url()->current(); ?>"/>
<link rel="canonical" href="<?php echo url()->current(); ?>"/>
<link rel='dns-prefetch' href='//fonts.gstatic.com'/>
<?php /**PATH /var/www/vhosts/porsionrouter.yeniproje.com/httpdocs/resources/views/_partials/meta.blade.php ENDPATH**/ ?>