<!DOCTYPE html PUBLIC>
<html lang="<?php echo e(_clang()); ?>">
<head>
    <meta charset="utf-8">
    <?php if(array_key_exists('metaTags', View::getSections())): ?>
        <?php echo $__env->yieldContent('metaTags'); ?>
    <?php else: ?>
        <?php $pageTitle = _config('site_name'); ?>
        <?php $pageIndex = 'index follow'; ?>
        <?php $pageDescription = _config('site_description'); ?>
        <?php $pageImage = _asset('images/logo.png'); ?>
    <?php endif; ?>
    <?php echo $__env->make('_partials.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("css/style.css")); ?>" media="screen"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("css/font/stylesheet.css")); ?>" media="screen"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("css/fancybox.css")); ?>" media="screen"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("noty/noty.css")); ?>" media="screen"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset("css/custom.css")); ?>" media="screen"/>
    <link rel="shortcut icon" href="<?php echo e(asset("favicon.png")); ?>" type="image/x-icon"/>

    <script type="text/javascript" src="<?php echo e(asset("js/jquery.min.js")); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset("js/nette.js")); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset("js/fancybox.js")); ?>"></script>


</head>

<body>

<div class="porsion">

    <!-- Start HEADER -->

    <header class="header">
        <div class="wrap">
            <div id="logo"><a href="<?php echo e(route("front.home")); ?>" alt="PorsiOn Food"><img
                            src="<?php echo e(asset("images/logo.png")); ?>"
                            alt="Porsion Logo"/></a></div>
            <div class="header-lang-wrap">
                <div class="header-lang-icon"><?php echo e(strtoupper(_clang())); ?></div>
                <div class="header-lang">
                    <ul>
                        <?php $__currentLoopData = _otherLangs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(_localizedCurrentUrl($key)); ?>"><?php echo e(strtoupper($key)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>

        </div>
    </header>

    <!-- Finish HEADER -->

    <!--	MAIN	-->

    <main>

        <!--	MAIN	-->

        <div class="slider-hero-wrap">

            <div class="slider-hero">

                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($slider->getMediaType() === true): ?>
                        <div class="slider-hero-item">
                            <video id="html5-video" class="slider-hero-video" autoplay="true" loop="loop" muted
                                   playsinline>
                                <source src="<?php echo e($slider->getMp4()); ?>" type="video/mp4">
                            </video>
                            <picture><img src="<?php echo e(asset("images/hero-mask.png")); ?>" alt=""/></picture>
                        </div>
                    <?php else: ?>
                        <div class="slider-hero-item">
                            <div class="item-zoom" style="background-image:url(<?php echo e($slider->getPhoto()); ?>);"></div>
                            <div class="slider-hero-title">
                                <div class="wrap">
                                    <!-- <div class="slider-hero-title-in"><strong>Bi' PorsiOn Daha?</strong></div> -->
                                </div>
                            </div>
                            <picture><img src="<?php echo e(asset("images/hero-mask.png")); ?>" alt=""/></picture>
                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="hero-cta">
                <div class="wrap">
                    <ul>
                        <?php $__currentLoopData = $redirects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redirect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($redirect->link); ?>" target="_blank"
                                   class="<?php echo e(strtolower($redirect->name)); ?>">
                                    <section>
                                        <?php if(_clang() == "en" && $redirect->id == 2): ?>
                                            <strong style="text-transform: uppercase; letter-spacing: 2px"><?php echo e("Retail"); ?></strong>
                                        <?php else: ?>
                                            <strong style="text-transform: uppercase; letter-spacing: 2px"><?php echo e($redirect->name); ?></strong>
                                        <?php endif; ?>
                                        <small><?php echo e($redirect->link_view); ?></small>
                                    </section>
                                    <picture><i><img src="<?php echo e($redirect->getPhoto()); ?>" alt=""/></i></picture>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>

        </div>

        <div class="w100 top-150 bottom-100">
            <div class="wrap reveal">
                <div class="block-narrow">
                    <div class="small-title text-orange"><?php echo e($pages["reveal"]->name); ?></div>
                </div>
                <div class="block-center">
                    <div class="page-title"><?php echo $pages["reveal"]->spot; ?></div>
                </div>
                <div class="block-right">
                    <div class="page-text"><?php echo $pages["reveal"]->content; ?></div>
                </div>
            </div>
        </div>

        <div class="w100">
            <div class="wrap">

                <div class="advantages-wrap reveal">
                    <picture><img src="<?php echo e($pages["4cards"]->getPhoto()); ?>" alt="" class="w100"/></picture>
                    <div class="porsion-advantages">
                        <ul>
                            <?php $__currentLoopData = $widgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="advantage-item">
                                        <section>
                                            <picture><img src="<?php echo e(str_replace("\\", "/", $widget->getPhoto())); ?>"
                                                          alt=""/>
                                            </picture>
                                            <strong><?php echo e($widget->name); ?></strong>
                                        </section>
                                        <small><?php echo $widget->content; ?></small>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>

            </div>
        </div>

        <div class="w100 top-100 bottom-100">
            <div class="wrap">

                <div class="porsion-stats bottom-100">
                    <ul>
                        <li>
                            <strong class="count"><?php echo e(_config("foundation")); ?></strong>
                            <small><?php echo trans("partials.foundation"); ?></small>
                        </li>
                        <li>
                            <strong class="count"><?php echo e(_config("horeca_customer")); ?></strong>
                            <small><?php echo trans("partials.horeca_customer"); ?></small>
                        </li>
                        <li>
                            <strong class="count"><?php echo e(_config("retail_customer")); ?></strong>
                            <small><?php echo trans("partials.retail_customer"); ?></small>
                        </li>
                        <li>
                            <strong class="count"><?php echo e(_config("product_range")); ?></strong>
                            <small><?php echo trans("partials.product_range"); ?></small>
                        </li>
                    </ul>
                </div>

                <div class="porsion-cta reveal">
                    <ul>
                        <?php $__currentLoopData = $redirects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redirect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($redirect->link); ?>" target="_blank">
                                    <picture><img src="<?php echo e($redirect->getBanner()); ?>" alt=""/></picture>
                                    <div class="wrap-in">
                                        <section>
                                            <?php if($redirect->id == 2 && _clang() == "en"): ?>
                                                <strong><?php echo e("Retail"); ?></strong>
                                            <?php else: ?>
                                                <strong><?php echo e($redirect->name); ?></strong>
                                            <?php endif; ?>
                                            <small><?php echo trans("partials.go_site"); ?></small>
                                        </section>
                                        <article><?php echo $redirect->content; ?></article>
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

            </div>
        </div>

        <!--	MAIN	-->

    </main>

    <!--	FOOTER	-->

    <footer class="w100 top-100">
        <div class="footer">
            <div class="wrap">

                <div class="wrap-in">
                    <div class="footer-top reveal">
                        <div class="footer-join">
                            <article>
                                <div class="page-title text-white"><?php echo trans("partials.newsletter_title"); ?></div>
                                <div class="page-text"><?php echo trans("partials.newsletter_content"); ?>

                                </div>
                            </article>
                            <section>
                                <?php echo html()->form('POST', route('front.newsletter'))->open(); ?>

                                <?php echo html()->email('email')->placeholder(trans('partials.newsletter_placeholder'))->id('s')->addClass('input')->required(true); ?>

                                <button id="send" class="button"><?php echo trans("partials.join"); ?></button>
                                <?php echo html()->form()->close(); ?>

                            </section>
                        </div>
                    </div>
                </div>

                <div class="footer-bottom">
                    <div class="wrap-in">
                        <div class="footer-logo"><a href="<?php echo e(route("front.home")); ?>"><img
                                        src="<?php echo e(asset("images/logo.png")); ?>" alt=""/></a>
                        </div>
                        <div class="footer-social">
                            <ul>
                                <li><a target="_blank" href="<?php echo e(_config("instagram")); ?>"><img
                                                src="<?php echo e(asset("images/icon-instagram.png")); ?>" alt="Porsion instagram"/></a>
                                </li>

                                <li><a target="_blank" href="<?php echo e(_config("facebook")); ?>"><img
                                                src="<?php echo e(asset("images/icon-facebook.png")); ?>"
                                                alt="Porsion facebook"/></a></li>

                                <li><a target="_blank" href="<?php echo e(_config("linkedin")); ?>"><img
                                                src="<?php echo e(asset("images/icon-linkedin.png")); ?>"
                                                alt="Porsion linkedin"/></a></li>
                            </ul>
                        </div>
                        <div class="footer-connect">
                            <section>
                                <h4><?php echo trans("partials.address"); ?></h4>
                                <article>
                                    <?php echo _config("contact_address"); ?>

                                </article>
                            </section>
                            <section>
                                <h4><?php echo trans("partials.contact"); ?></h4>
                                <article>
                                    <?php echo _config("contact_phone"); ?>

                                    <br/>
                                    <?php echo _config("contact_fax"); ?>

                                    <br/>
                                    <?php echo _config("contact_mail"); ?>

                                </article>
                            </section>
                        </div>
                    </div>
                </div>

                <div class="copyright">
                    <div class="wrap-in">
                        <div class="left">
                            <a data-fancybox data-src="#fancy-kvkk"
                               href="javascript:;"><?php echo $policies["pdpl"]->name; ?></a>
                            <a data-fancybox data-src="#fancy-confident"
                               href="javascript:;"><?php echo $policies["confident"]->name; ?></a>
                            <small>Copyright © 2024. PorsiOn Food</small>
                        </div>
                        <div class="right"><a href="https://nette.com.tr" target="_blank"><img
                                        src="<?php echo e(asset("images/nette.png")); ?>"
                                        alt="Nette Agency Logo"/>designed by</a></div>
                    </div>
                </div>

            </div>
        </div>
    </footer>

    <!--	FOOTER	-->

</div>

<div class="cookies-wrap">
    <div class="cookies">
        <section>PorsiOn Food sağlanan hizmetlerin iyileştirilmesi ve web sitesinde en iyi deneyimi yaşamanızı sağlamak
            için çerezleri kullanır.
        </section>
        <div class="cookies-close"><span>close</span></div>
    </div>
</div>

<script type="text/javascript" src="<?php echo e(asset("js/slick.min.js")); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset("js/sticky.js")); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset("noty/noty.js")); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset("noty/noty.settings.js")); ?>"></script>
<?php echo $__env->make('_partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="my-fancy" id="fancy-kvkk">
    <div class="my-fancy-wrap">
        <div class="fancy-title"><strong><?php echo $policies["pdpl"]->name; ?></strong></div>
        <div><?php echo $policies["pdpl"]->content; ?></div>
    </div>
</div>

<div class="my-fancy" id="fancy-confident">
    <div class="my-fancy-wrap">
        <div class="fancy-title"><strong><?php echo $policies["confident"]->name; ?></strong></div>
        <div><?php echo $policies["confident"]->content; ?></div>
    </div>
</div>

</body>
</html><?php /**PATH /var/www/vhosts/porsionrouter.yeniproje.com/httpdocs/resources/views/main.blade.php ENDPATH**/ ?>