<script type="text/javascript">

    axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';


    //region Dashboard Ajax Manager
    var dashBoardAjaxManager = (function () {
        var requests = [];

        return {
            //ADD REQUEST
            addReq: function (request, callback, failed, upload) {
                requests.push({
                    request: (request || ({url: '/', data: {}})),
                    callback: (callback || function (result) {
                    }),
                    failed: (failed || function (error) {
                    }),
                    upload: (upload || function (progressEvent) {
                    })
                });

            },
            run: function () {
                var self = this;

                if (requests.length) {
                    var axiosConfig = {
                        headers: {'Content-Type': 'multipart/form-data'},
                        onUploadProgress: requests[0].upload
                    };
                    axios
                        .post((requests[0].request.url || '/'), (requests[0].request.data || {}), axiosConfig)
                        .then(function (response) {
                            requests[0].callback(response);
                            requests.shift();
                            self.run.apply(self, []);
                        })
                        .catch(function (error) {
                            requests[0].failed(error);
                            requests.shift();
                            self.run.apply(self, []);
                        });

                } else {
                    self.tid = setTimeout(function () {
                        self.run.apply(self, []);
                    }, 1000);
                }
            },
            stop: function () {
                requests = [];
                clearTimeout(this.tid);
            }
        };
    }());
    //Ajax Manager ı başlatıyoruz
    dashBoardAjaxManager.run();

    //endregion


    function sparkline(element, chartType, qty, height, interpolation, duration, interval, color) {

        var d3Container = d3.select(element),
            margin = {top: 0, right: 0, bottom: 0, left: 0},
            width = d3Container.node().getBoundingClientRect().width - margin.left - margin.right,
            height = height - margin.top - margin.bottom;

        var data = [];
        for (var i = 0; i < qty; i++) {
            data.push(Math.floor(Math.random() * qty) + 5)
        }

        var x = d3.scale.linear().range([0, width]);
        var y = d3.scale.linear().range([height - 5, 5]);

        x.domain([1, qty - 3])
        y.domain([0, qty])


        var line = d3.svg.line()
            .interpolate(interpolation)
            .x(function (d, i) {
                return x(i);
            })
            .y(function (d, i) {
                return y(d);
            });

        // Area
        var area = d3.svg.area()
            .interpolate(interpolation)
            .x(function (d, i) {
                return x(i);
            })
            .y0(height)
            .y1(function (d) {
                return y(d);
            });


        var container = d3Container.append('svg');

        var svg = container
            .attr('width', width + margin.left + margin.right)
            .attr('height', height + margin.top + margin.bottom)
            .append("g")
            .attr("transform", "translate(" + margin.left + "," + margin.top + ")");


        var clip = svg.append("defs")
            .append("clipPath")
            .attr('id', function (d, i) {
                return "load-clip-" + element.substring(1)
            })

        var clips = clip.append("rect")
            .attr('class', 'load-clip')
            .attr("width", 0)
            .attr("height", height);

        clips
            .transition()
            .duration(1000)
            .ease('linear')
            .attr("width", width);

        var path = svg.append("g")
            .attr("clip-path", function (d, i) {
                return "url(#load-clip-" + element.substring(1) + ")"
            })
            .append("path")
            .datum(data)
            .attr("transform", "translate(" + x(0) + ",0)");

        // Add path based on chart type
        if (chartType == "area") {
            path.attr("d", area).attr('class', 'd3-area').style("fill", color); // area
        } else {
            path.attr("d", line).attr("class", "d3-line d3-line-medium").style('stroke', color); // line
        }
        path
            .style('opacity', 0)
            .transition()
            .duration(750)
            .style('opacity', 1);

        setInterval(function () {

            data.push(Math.floor(Math.random() * qty) + 5);
            data.shift();

            update();

        }, interval);

        function update() {
            path
                .attr("transform", null)
                .transition()
                .duration(duration)
                .ease("linear")
                .attr("transform", "translate(" + x(0) + ",0)");

            // Update path type
            if (chartType == "area") {
                path.attr("d", area).attr('class', 'd3-area').style("fill", color)
            } else {
                path.attr("d", line).attr("class", "d3-line d3-line-medium").style('stroke', color);
            }
        }

        $(window).on('resize', resizeSparklines);
        $(document).on('click', '.sidebar-control', resizeSparklines);

        function resizeSparklines() {

            width = d3Container.node().getBoundingClientRect().width - margin.left - margin.right;

            container.attr("width", width + margin.left + margin.right);

            svg.attr("width", width + margin.left + margin.right);

            x.range([0, width]);


            clips.attr("width", width);

            svg.select(".d3-line").attr("d", line);
            svg.select(".d3-area").attr("d", area);
        }
    };

    <?php if(checkPermission('analytics.view')): ?>
    function _analyticsData() {
        var data = new FormData();

        var failCalllback = function (error) {
            console.log(error);
        }
        var successCallback = function (response) {
            var rdata = response.data

            if (data.status == 'fail') {
                error('Error!', data.message);
            } else {
                var axis_categorized = c3.generate({
                    bindto: '#c3-axis-categorized',
                    size: {height: 400},
                    data: {
                        columns: [
                            rdata.data.views,
                            rdata.data.visitors
                        ]
                    },
                    color: {
                        pattern: ['#03A9F4', '#4ab71f']
                    },
                    axis: {
                        x: {
                            type: 'category',
                            categories: rdata.data.categories
                        }
                    },
                    grid: {
                        x: {
                            show: true
                        },
                        y: {
                            show: true
                        }
                    }
                });

            }

        }
        var upload = function (progressEvent) {

        }
        var request = {
            url: '<?php echo route('admin.analytics.data'); ?>',
            data: data
        }

        return {
            request: request,
            callback: successCallback,
            failed: failCalllback,
            upload: upload
        }
    };

    var requestObject = _analyticsData();

    dashBoardAjaxManager.addReq(requestObject.request, requestObject.callback, requestObject.failed, requestObject.upload);

    function _visitorsData() {
        var data = new FormData();

        var failCalllback = function (error) {
            console.log(error);
        }
        var successCallback = function (response) {
            var rdata = response.data

            if (rdata.status == 'fail') {
                error('Error!', data.message);
            } else {
                $(".newVisitor").html(rdata.data[0].sessions);
                $(".returningVisitor").html(rdata.data[1].sessions);
                sparkline("#new-visitors", "line", 30, 35, "basis", 750, 2000, "#26A69A");
                sparkline("#new-sessions", "line", 30, 35, "basis", 750, 2000, "#FF7043");
                sparkline("#total-online", "line", 30, 35, "basis", 750, 2000, "#5C6BC0");
            }

        }
        var upload = function (progressEvent) {

        }
        var request = {
            url: '<?php echo route('admin.analytics.visitors'); ?>',
            data: data
        }

        return {
            request: request,
            callback: successCallback,
            failed: failCalllback,
            upload: upload
        }
    };

    var requestObject = _visitorsData();
    dashBoardAjaxManager.addReq(requestObject.request, requestObject.callback, requestObject.failed, requestObject.upload);

    var _browserdonut = function (element, size, data) {
        if (typeof d3 == 'undefined') {
            console.warn('Warning - d3.min.js is not loaded.');
            return;
        }

        if ($(element).length > 0) {
            // Main variables
            var d3Container = d3.select(element),
                distance = 2, // reserve 2px space for mouseover arc moving
                radius = (size / 2) - distance,
                sum = d3.sum(data, function (d) {
                    return d.value;
                });


            // Tooltip
            // ------------------------------

            var tip = d3.tip()
                .attr('class', 'd3-tip')
                .offset([-10, 0])
                .direction('e')
                .html(function (d) {
                    return '<ul class="list-unstyled mb-1">' +
                        '<li>' + '<div class="font-size-base mb-1 mt-1">' + d.data.browser + '</div>' + '</li>' +
                        '<li>' + 'Sayı: &nbsp;' + '<span class="font-weight-semibold float-right">' + d.value + '</span>' + '</li>' +
                        '</ul>';
                });


            // Create chart
            // ------------------------------

            // Add svg element
            var container = d3Container.append('svg').call(tip);

            // Add SVG group
            var svg = container
                .attr('width', size)
                .attr('height', size)
                .append('g')
                .attr('transform', 'translate(' + (size / 2) + ',' + (size / 2) + ')');


            // Construct chart layout
            // ------------------------------

            // Pie
            var pie = d3.layout.pie()
                .sort(null)
                .startAngle(Math.PI)
                .endAngle(3 * Math.PI)
                .value(function (d) {
                    return d.value;
                });

            // Arc
            var arc = d3.svg.arc()
                .outerRadius(radius)
                .innerRadius(radius / 2);


            //
            // Append chart elements
            //

            // Group chart elements
            var arcGroup = svg.selectAll('.d3-arc')
                .data(pie(data))
                .enter()
                .append('g')
                .attr('class', 'd3-arc')
                .style('stroke', '#fff')
                .style('cursor', 'pointer');

            // Append path
            var arcPath = arcGroup
                .append('path')
                .style('fill', function (d) {
                    return d.data.color;
                });

            // Add tooltip
            arcPath
                .on('mouseover', function (d, i) {

                    // Transition on mouseover
                    d3.select(this)
                        .transition()
                        .duration(500)
                        .ease('elastic')
                        .attr('transform', function (d) {
                            d.midAngle = ((d.endAngle - d.startAngle) / 2) + d.startAngle;
                            var x = Math.sin(d.midAngle) * distance;
                            var y = -Math.cos(d.midAngle) * distance;
                            return 'translate(' + x + ',' + y + ')';
                        });
                })

                .on('mousemove', function (d) {

                    // Show tooltip on mousemove
                    tip.show(d)
                        .style('top', (d3.event.pageY - 40) + 'px')
                        .style('left', (d3.event.pageX + 30) + 'px');
                })

                .on('mouseout', function (d, i) {

                    // Mouseout transition
                    d3.select(this)
                        .transition()
                        .duration(500)
                        .ease('bounce')
                        .attr('transform', 'translate(0,0)');

                    // Hide tooltip
                    tip.hide(d);
                });

            // Animate chart on load
            arcPath
                .transition()
                .delay(function (d, i) {
                    return i * 10;
                })
                .duration(100)
                .attrTween('d', function (d) {
                    var interpolate = d3.interpolate(d.startAngle, d.endAngle);
                    return function (t) {
                        d.endAngle = interpolate(t);
                        return arc(d);
                    };
                });
        }
    };
    var _platformdonut = function (element, size, data) {
        if (typeof d3 == 'undefined') {
            console.warn('Warning - d3.min.js is not loaded.');
            return;
        }

        if ($(element).length > 0) {
            // Main variables
            var d3Container = d3.select(element),
                distance = 2, // reserve 2px space for mouseover arc moving
                radius = (size / 2) - distance,
                sum = d3.sum(data, function (d) {
                    return d.value;
                });


            // Tooltip
            // ------------------------------

            var tip = d3.tip()
                .attr('class', 'd3-tip')
                .offset([-10, 0])
                .direction('e')
                .html(function (d) {
                    return '<ul class="list-unstyled mb-1">' +
                        '<li>' + '<div class="font-size-base mb-1 mt-1">' + d.data.platform + '</div>' + '</li>' +
                        '<li>' + 'Sayı: &nbsp;' + '<span class="font-weight-semibold float-right">' + d.value + '</span>' + '</li>' +
                        '</ul>';
                });


            // Create chart
            // ------------------------------

            // Add svg element
            var container = d3Container.append('svg').call(tip);

            // Add SVG group
            var svg = container
                .attr('width', size)
                .attr('height', size)
                .append('g')
                .attr('transform', 'translate(' + (size / 2) + ',' + (size / 2) + ')');


            // Construct chart layout
            // ------------------------------

            // Pie
            var pie = d3.layout.pie()
                .sort(null)
                .startAngle(Math.PI)
                .endAngle(3 * Math.PI)
                .value(function (d) {
                    return d.value;
                });

            // Arc
            var arc = d3.svg.arc()
                .outerRadius(radius)
                .innerRadius(radius / 2);


            //
            // Append chart elements
            //

            // Group chart elements
            var arcGroup = svg.selectAll('.d3-arc')
                .data(pie(data))
                .enter()
                .append('g')
                .attr('class', 'd3-arc')
                .style('stroke', '#fff')
                .style('cursor', 'pointer');

            // Append path
            var arcPath = arcGroup
                .append('path')
                .style('fill', function (d) {
                    return d.data.color;
                });

            // Add tooltip
            arcPath
                .on('mouseover', function (d, i) {

                    // Transition on mouseover
                    d3.select(this)
                        .transition()
                        .duration(500)
                        .ease('elastic')
                        .attr('transform', function (d) {
                            d.midAngle = ((d.endAngle - d.startAngle) / 2) + d.startAngle;
                            var x = Math.sin(d.midAngle) * distance;
                            var y = -Math.cos(d.midAngle) * distance;
                            return 'translate(' + x + ',' + y + ')';
                        });
                })

                .on('mousemove', function (d) {

                    // Show tooltip on mousemove
                    tip.show(d)
                        .style('top', (d3.event.pageY - 40) + 'px')
                        .style('left', (d3.event.pageX + 30) + 'px');
                })

                .on('mouseout', function (d, i) {

                    // Mouseout transition
                    d3.select(this)
                        .transition()
                        .duration(500)
                        .ease('bounce')
                        .attr('transform', 'translate(0,0)');

                    // Hide tooltip
                    tip.hide(d);
                });

            // Animate chart on load
            arcPath
                .transition()
                .delay(function (d, i) {
                    return i * 10;
                })
                .duration(100)
                .attrTween('d', function (d) {
                    var interpolate = d3.interpolate(d.startAngle, d.endAngle);
                    return function (t) {
                        d.endAngle = interpolate(t);
                        return arc(d);
                    };
                });
        }
    };
    function _browserData() {
        var data = new FormData();

        var failCalllback = function (error) {
            console.log(error);
        }
        var successCallback = function (response) {
            var rdata = response.data

            if (rdata.status == 'fail') {
                error('Error!', data.message);
            } else {
                _browserdonut('#browser-donut', 100, rdata.data.browser);
                _platformdonut('#platform-donut', 100, rdata.data.platform);
            }

        }
        var upload = function (progressEvent) {

        }
        var request = {
            url: '<?php echo route('admin.analytics.browser'); ?>',
            data: data
        }

        return {
            request: request,
            callback: successCallback,
            failed: failCalllback,
            upload: upload
        }
    };

    var requestObject = _browserData();
    dashBoardAjaxManager.addReq(requestObject.request, requestObject.callback, requestObject.failed, requestObject.upload);
    <?php endif; ?>
</script>
<?php /**PATH C:\Root\work\nette\porsion\porsion-main-router\vendor\nette\admin\src\Nette\Admin/../../views/_js/dashboard.blade.php ENDPATH**/ ?>