<?php

use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['as' => 'front.'], function () {
    Route::group(['prefix' => LaravelLocalization::setLocale(), 'middleware' => ['localizationRedirect', 'localize']], function () {
        Route::get('/', ['as' => 'home', 'uses' => 'FrontBaseController@index']);
        Route::post(LaravelLocalization::transRoute("routes.newsletter"), ['as' => 'newsletter', 'uses' => 'FrontBaseController@newsletter']);
//        Route::get(LaravelLocalization::transRoute('routes.about'),['as' => 'about', 'uses' => 'PageController@about']);
    });
});
