<!DOCTYPE html PUBLIC>
<html lang="{{ _clang() }}">
<head>
    <meta charset="utf-8">
    @if(array_key_exists('metaTags', View::getSections()))
        @yield('metaTags')
    @else
        @pageTitle(_config('site_name'))
        @pageIndex('index follow')
        @pageDescription(_config('site_description'))
        @pageImage(_asset('images/logo.png'))
    @endif
    @include('_partials.meta')

    <link rel="stylesheet" type="text/css" href="{{ asset("css/style.css") }}" media="screen"/>
    <link rel="stylesheet" type="text/css" href="{{ asset("css/font/stylesheet.css") }}" media="screen"/>
    <link rel="stylesheet" type="text/css" href="{{ asset("css/fancybox.css") }}" media="screen"/>
    <link rel="stylesheet" type="text/css" href="{{ asset("noty/noty.css") }}" media="screen"/>
    <link rel="stylesheet" type="text/css" href="{{ asset("css/custom.css") }}" media="screen"/>
    <link rel="shortcut icon" href="{{ asset("favicon.png") }}" type="image/x-icon"/>

    <script type="text/javascript" src="{{ asset("js/jquery.min.js") }}"></script>
    <script type="text/javascript" src="{{ asset("js/nette.js") }}"></script>
    <script type="text/javascript" src="{{ asset("js/fancybox.js") }}"></script>


</head>

<body>

<div class="porsion">

    <!-- Start HEADER -->

    <header class="header">
        <div class="wrap">
            <div id="logo"><a href="{{ route("front.home") }}" alt="PorsiOn Food"><img
                            src="{{ asset("images/logo.png") }}"
                            alt="Porsion Logo"/></a></div>
            <div class="header-lang-wrap">
                <div class="header-lang-icon">{{ strtoupper(_clang())  }}</div>
                <div class="header-lang">
                    <ul>
                        @foreach(_otherLangs() as $key=>$val)
                            <li><a href="{{  _localizedCurrentUrl($key) }}">{{ strtoupper($key) }}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>

        </div>
    </header>

    <!-- Finish HEADER -->

    <!--	MAIN	-->

    <main>

        <!--	MAIN	-->

        <div class="slider-hero-wrap">

            <div class="slider-hero">

                @foreach($sliders as $slider)
                    @if($slider->getMediaType() === true)
                        <div class="slider-hero-item">
                            <video id="html5-video" class="slider-hero-video" autoplay="true" loop="loop" muted
                                   playsinline>
                                <source src="{{ $slider->getMp4() }}" type="video/mp4">
                            </video>
                            <picture><img src="{{ asset("images/hero-mask.png") }}" alt=""/></picture>
                        </div>
                    @else
                        <div class="slider-hero-item">
                            <div class="item-zoom" style="background-image:url({{ $slider->getPhoto() }});"></div>
                            <div class="slider-hero-title">
                                <div class="wrap">
                                    <!-- <div class="slider-hero-title-in"><strong>Bi' PorsiOn Daha?</strong></div> -->
                                </div>
                            </div>
                            <picture><img src="{{ asset("images/hero-mask.png") }}" alt=""/></picture>
                        </div>
                    @endif
                @endforeach
            </div>

            <div class="hero-cta">
                <div class="wrap">
                    <ul>
                        @foreach($redirects as $redirect)
                            <li>
                                <a href="{{ $redirect->link }}" target="_blank"
                                   class="{{ strtolower($redirect->name) }}">
                                    <section>
                                        @if(_clang() == "en" && $redirect->id == 2)
                                            <strong style="text-transform: uppercase; letter-spacing: 2px">{{ "Retail" }}</strong>
                                        @else
                                            <strong style="text-transform: uppercase; letter-spacing: 2px">{{ $redirect->name }}</strong>
                                        @endif
                                        <small>{{ $redirect->link_view }}</small>
                                    </section>
                                    <picture><i><img src="{{ $redirect->getPhoto() }}" alt=""/></i></picture>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

        </div>

        <div class="w100 top-150 bottom-100">
            <div class="wrap reveal">
                <div class="block-narrow">
                    <div class="small-title text-orange">{{ $pages["reveal"]->name }}</div>
                </div>
                <div class="block-center">
                    <div class="page-title">{!! $pages["reveal"]->spot !!}</div>
                </div>
                <div class="block-right">
                    <div class="page-text">{!! $pages["reveal"]->content !!}</div>
                </div>
            </div>
        </div>

        <div class="w100">
            <div class="wrap">

                <div class="advantages-wrap reveal">
                    <picture><img src="{{ $pages["4cards"]->getPhoto() }}" alt="" class="w100"/></picture>
                    <div class="porsion-advantages">
                        <ul>
                            @foreach($widgets as $widget)
                                <li>
                                    <div class="advantage-item">
                                        <section>
                                            <picture><img src="{{ str_replace("\\", "/", $widget->getPhoto()) }}"
                                                          alt=""/>
                                            </picture>
                                            <strong>{{ $widget->name }}</strong>
                                        </section>
                                        <small>{!! $widget->content !!}</small>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>

            </div>
        </div>

        <div class="w100 top-100 bottom-100">
            <div class="wrap">

                <div class="porsion-stats bottom-100">
                    <ul>
                        <li>
                            <strong class="count">{{ _config("foundation") }}</strong>
                            <small>{!! trans("partials.foundation") !!}</small>
                        </li>
                        <li>
                            <strong class="count">{{ _config("horeca_customer") }}</strong>
                            <small>{!! trans("partials.horeca_customer") !!}</small>
                        </li>
                        <li>
                            <strong class="count">{{ _config("retail_customer") }}</strong>
                            <small>{!! trans("partials.retail_customer") !!}</small>
                        </li>
                        <li>
                            <strong class="count">{{ _config("product_range") }}</strong>
                            <small>{!! trans("partials.product_range") !!}</small>
                        </li>
                    </ul>
                </div>

                <div class="porsion-cta reveal">
                    <ul>
                        @foreach($redirects as $redirect)
                            <li>
                                <a href="{{ $redirect->link }}" target="_blank">
                                    <picture><img src="{{ $redirect->getBanner() }}" alt=""/></picture>
                                    <div class="wrap-in">
                                        <section>
                                            @if($redirect->id == 2 && _clang() == "en")
                                                <strong>{{ "Retail" }}</strong>
                                            @else
                                                <strong>{{ $redirect->name }}</strong>
                                            @endif
                                            <small>{!! trans("partials.go_site") !!}</small>
                                        </section>
                                        <article>{!! $redirect->content !!}</article>
                                    </div>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>

            </div>
        </div>

        <!--	MAIN	-->

    </main>

    <!--	FOOTER	-->

    <footer class="w100 top-100">
        <div class="footer">
            <div class="wrap">

                <div class="wrap-in">
                    <div class="footer-top reveal">
                        <div class="footer-join">
                            <article>
                                <div class="page-title text-white">{!! trans("partials.newsletter_title") !!}</div>
                                <div class="page-text">{!! trans("partials.newsletter_content") !!}
                                </div>
                            </article>
                            <section>
                                {!! html()->form('POST', route('front.newsletter'))->open() !!}
                                {!! html()->email('email')->placeholder(trans('partials.newsletter_placeholder'))->id('s')->addClass('input')->required(true) !!}
                                <button id="send" class="button">{!! trans("partials.join") !!}</button>
                                {!! html()->form()->close() !!}
                            </section>
                        </div>
                    </div>
                </div>

                <div class="footer-bottom">
                    <div class="wrap-in">
                        <div class="footer-logo"><a href="{{ route("front.home") }}"><img
                                        src="{{ asset("images/logo.png") }}" alt=""/></a>
                        </div>
                        <div class="footer-social">
                            <ul>
                                <li><a target="_blank" href="{{ _config("instagram") }}"><img
                                                src="{{ asset("images/icon-instagram.png") }}" alt="Porsion instagram"/></a>
                                </li>

                                <li><a target="_blank" href="{{ _config("facebook") }}"><img
                                                src="{{ asset("images/icon-facebook.png") }}"
                                                alt="Porsion facebook"/></a></li>

                                <li><a target="_blank" href="{{ _config("linkedin") }}"><img
                                                src="{{ asset("images/icon-linkedin.png") }}"
                                                alt="Porsion linkedin"/></a></li>
                            </ul>
                        </div>
                        <div class="footer-connect">
                            <section>
                                <h4>{!! trans("partials.address") !!}</h4>
                                <article>
                                    {!! _config("contact_address") !!}
                                </article>
                            </section>
                            <section>
                                <h4>{!! trans("partials.contact") !!}</h4>
                                <article>
                                    {!! _config("contact_phone") !!}
                                    <br/>
                                    {!! _config("contact_fax") !!}
                                    <br/>
                                    {!! _config("contact_mail") !!}
                                </article>
                            </section>
                        </div>
                    </div>
                </div>

                <div class="copyright">
                    <div class="wrap-in">
                        <div class="left">
                            <a data-fancybox data-src="#fancy-kvkk"
                               href="javascript:;">{!! $policies["pdpl"]->name !!}</a>
                            <a data-fancybox data-src="#fancy-confident"
                               href="javascript:;">{!! $policies["confident"]->name !!}</a>
                            <small>Copyright © 2024. PorsiOn Food</small>
                        </div>
                        <div class="right"><a href="https://nette.com.tr" target="_blank"><img
                                        src="{{ asset("images/nette.png") }}"
                                        alt="Nette Agency Logo"/>designed by</a></div>
                    </div>
                </div>

            </div>
        </div>
    </footer>

    <!--	FOOTER	-->

</div>

<div class="cookies-wrap">
    <div class="cookies">
        <section>PorsiOn Food sağlanan hizmetlerin iyileştirilmesi ve web sitesinde en iyi deneyimi yaşamanızı sağlamak
            için çerezleri kullanır.
        </section>
        <div class="cookies-close"><span>close</span></div>
    </div>
</div>

<script type="text/javascript" src="{{ asset("js/slick.min.js") }}"></script>
<script type="text/javascript" src="{{ asset("js/sticky.js") }}"></script>
<script type="text/javascript" src="{{ asset("noty/noty.js") }}"></script>
<script type="text/javascript" src="{{ asset("noty/noty.settings.js") }}"></script>
@include('_partials.status')

<div class="my-fancy" id="fancy-kvkk">
    <div class="my-fancy-wrap">
        <div class="fancy-title"><strong>{!! $policies["pdpl"]->name !!}</strong></div>
        <div>{!! $policies["pdpl"]->content !!}</div>
    </div>
</div>

<div class="my-fancy" id="fancy-confident">
    <div class="my-fancy-wrap">
        <div class="fancy-title"><strong>{!! $policies["confident"]->name !!}</strong></div>
        <div>{!! $policies["confident"]->content !!}</div>
    </div>
</div>

</body>
</html>