<title>{{ (isset($pageTitle))?$pageTitle:trans('meta.title') }}</title>
<meta name="csrf-token" content="{!! csrf_token() !!}"/>
<meta name="theme-color" content="#ffffff"/>
<meta name="msapplication-navbutton-color" content="#ffffff">
<meta name="apple-mobile-web-app-status-bar-style" content="#ffffff">

@if($current_menu == 'home')
    <meta name="description" content="{!! _config('site_description') !!}"/>
@else
    <meta name="description" content="{!! isset($pageDescription) ? $pageDescription: _config('site_description') !!}"/>
@endif

<meta name="author" content="{{ _config('site_author','') }}"/>
<meta property="og:site_name" content="{{ _config('site_name') }}"/>
<meta property="og:url" content="{{ (isset($pageUrl))?$pageUrl:Request::url() }}"/>
<meta property="description" content="{{ isset($pageDescription) ? $pageDescription: _config('site_description') }}"/>
<meta property="og:type" content="{{ (isset($pageType_og))?$pageType_og:'article' }}"/>
<meta property="og:title" content="{{ (isset($pageTitle))?$pageTitle:_config("site_name") }}"/>
<meta property="og:description" content="{{ isset($pageDescription) ? $pageDescription: trans('meta.description') }}"/>
<meta property="og:image" content="{!! isset($pageImage) ? $pageImage: _asset('images/logo.png') !!}"/>

<meta name="image" itemprop="image" content="{!! isset($pageImage) ? $pageImage: _asset('images/logo.png') !!}"/>
@isset($pageThumbnail)
    <meta name="thumbnail" itemprop="thumbnailUrl"
          content="{!! $pageThumbnail ? $pageThumbnail :  _asset('images/logo.png') !!}"/>
@endisset

<meta property="twitter:site" content="{{ _config('twitter_handle') }}"/>
<meta property="twitter:creator" content="{{ _config('twitter_handle') }}"/>
<meta property="twitter:card" content="{{ (isset($pageType_twitter))?$pageType_twitter:'summary'  }}"/>
<meta property="twitter:url" content="{{ (isset($pageUrl))?$pageUrl:Request::url() }}"/>
<meta property="twitter:domain" content="{{ (isset($pageDomain))?$pageDomain:config('app.url') }}"/>
<meta property="twitter:title" content=" {{ (isset($pageTitle))?$pageTitle:_config("site_name") }}"/>
<meta property="twitter:description" content="{{ isset($pageDescription) ? $pageDescription: _config("site_name") }}"/>
<meta property="twitter:image" content="{{  isset($pageImage) ? $pageImage: asset('assets/images/logo.png') }}"/>

@if(_clang() == "tr")
    <meta http-equiv="content-language" content="tr-TR"/>
    <meta itemprop="inLanguage" content="tr"/>
@elseif(_clang() == "en")
    <meta http-equiv="content-language" content="en-US"/>
    <meta itemprop="inLanguage" content="en"/>
@else
    <meta http-equiv="content-language" content="ru-RU"/>
    <meta itemprop="inLanguage" content="ru"/>
@endif

@if(!isset($metaRobots))
    @if ((env('APP_ENV') == 'local') || (env('APP_ENV') == 'testing'))
        <meta name="robots" content="noindex nofollow">
    @else
        <meta name="robots" content="index follow">
    @endif
@else
    <meta name="robots" content="{!! $metaRobots !!}">
@endif
@isset($isNews)
    <meta name="genre" itemprop="genre" content="News"/>
    <meta itemprop="isFamilyFriendly" content="True"/>
@endisset
<meta name="url" itemprop="url" content="{!! url()->current() !!}"/>
<link rel="canonical" href="{!! url()->current() !!}"/>
<link rel='dns-prefetch' href='//fonts.gstatic.com'/>
