<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWidgetPackage extends Migration
{

    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('widgets', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name', false, 128);
            $table->multiLangText('content', true);
            $table->integer('author')->nullable();
            $table->bigInteger("photo_id")->nullable();
            $table->integer('edit_author')->nullable();
            $table->integer('order_number')->default(0);
            $table->boolean('shareable')->default(true)->index();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('status')->default(false);
            $table->timestamp('date')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        $schema->create('widget_gallery', function(ExtendedBlueprint $table){
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->longText('title')->nullable();
            $table->longText('caption')->nullable();
            $table->text('source')->nullable();
            $table->integer('order')->default(0);
            $table->integer('widget_id')->unsigned();
            $table->foreign('widget_id')->references('id')->on('widgets')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('media_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade')->onUpdate('cascade');
        });
    }


    public function down()
    {
        Schema::dropIfExists('widget_gallery');
        Schema::dropIfExists('widgets');
    }
}
