<?php

namespace App\Packages\Widget\Models;


use App\Packages\Article\Models\Article;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\Page;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Widget extends BaseModel
{

    use SoftDeletes;
    use Sluggable;
    use SlugTrait;
    use MultiLingualModel;

    protected $table = 'widgets';

    protected $multiLingualFillable
        = [
            'name',
            'content',
            'slug',
        ];

    protected $fillable
        = [
            'author',
            'edit_author',
            'status',
            'created_at',
            'photo_id',
            'type',
        ];

    protected $hidden
        = [

        ];

    protected $casts
        = [
        ];

    protected $with = ['photo'];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];


    public static $checks
        = [
            'status',
        ];

    public static $zeros
        = [

        ];

    public static $rules
        = [
            //        'name' => 'required',
        ];

    public static $multiLingualRules
        = [
            'name' => 'required',
        ];

    public static $attr
        = [
            'name' => 'Materyal adı',
        ];

    public static $slug = [
        'name' => 'slug',
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public function photo()
    {
        return $this->hasOne(Media::class, "id", "photo_id");
    }

    public function getPhoto($variation = null)
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : asset("special/no-image.jpg");
    }

    public function images()
    {
        return $this->belongsToMany(Media::class, 'widget_gallery', 'widget_id', 'media_id')->withPivot('title', 'caption', 'order',
            'source')->orderBy('widget_gallery.order', 'ASC');
    }

}
