<?php

use Ramsey\Uuid\Uuid;
use Illuminate\Database\Seeder;

use App\Packages\Slider\Models\Slider;
use UploadManager as Up;

class RandomSlider extends Seeder
{
    public function run()
    {
        $faker = \Faker\Factory::create("tr_TR");

        $howManySliders = $faker->numberBetween(5, 10);

        for ($i = 0; $i < $howManySliders; $i++) {

            $insertItem = [];
            if (config('nette-lang.enable')) {
                foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang) {
                    $insertItem['name_' . $key] = $faker->words(6, true);
                    $insertItem['url_' . $key] = '#';
                }
            } else {
                $insertItem['name'] = $faker->words(6, true);
                $insertItem['url'] = '#';
            }


            $insertItem['page_key'] = 'homepage';
            $insertItem['status'] = 1;

            $randomPicture = Slider::create($insertItem);

            $uuid = Uuid::uuid4()->toString();
            Up::set($uuid);
            Up::add('img', 'slider', ['payload' => config('upload.mockImage')], null, false, 'url');
            $itemPhoto = Up::save('img', 'slider');


            if ($itemPhoto->id !== null) {
                $randomPicture->photo_id = $itemPhoto->id;
            }

            echo "X";

            $randomPicture->save();

        }
        echo PHP_EOL;


    }
}
