<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSliderPackage extends Migration
{

    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('sliders', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name', true, 128);
            $table->multiLangString('video_url', true, 128);
            $table->multiLangString('url', true, 128);
            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->integer('order_number')->default(0);
            $table->boolean('shareable')->default(true)->index();
            $table->bigInteger('photo_id_tr')->unsigned()->nullable();
            $table->bigInteger('photo_id_en')->unsigned()->nullable();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('status')->default(false);
            $table->boolean('video_status')->default(false);
            $table->timestamp('date')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }


    public function down()
    {
        Schema::dropIfExists('sliders');
    }
}
