<?php

namespace App\Packages\Slider\Models;


use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\Page;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Slider extends BaseModel
{

    use SoftDeletes;
    use MultiLingualModel;

    protected $table = 'sliders';

    protected $multiLingualFillable
        = [
            'name',
            'slogan',
            'video_url',
            'url',
        ];

    protected $fillable
        = [
            'author',
            'edit_author',
            'status',
            'video_status',
            'location_type',
            'photo_id_tr',
            'photo_id_en',
            'video_id_tr',
            'video_id_en',
            'created_at',
        ];

    protected $hidden
        = [

        ];

    protected $casts
        = [
            'meta' => 'array',
        ];

    protected $with = [];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];


    public static $checks
        = [
            'status',
        ];

    public static $zeros
        = [

        ];

    public static $rules
        = [
            //        'name' => 'required',
        ];

    public static $multiLingualRules
        = [
//            'name' => 'required',
        ];

    public static $attr
        = [
            'name' => 'Slider adı',
        ];

    public function phototr()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id_tr');
    }

    public function photoen()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id_en');
    }

    public function mp4tr()
    {
        return $this->hasOne(Media::class, 'id', 'video_id_tr');
    }

    public function mp4en()
    {
        return $this->hasOne(Media::class, 'id', 'video_id_en');
    }

    public function getPhoto()
    {
        $isTurkish = _clang() == "tr";

        if ($isTurkish && $this->photo_id_tr) {
            return str_replace("\\", "/", $this->phototr->url());
        }

        if (!$isTurkish && $this->photo_id_en) {
            return str_replace("\\", "/", $this->photoen->url());
        }

        if ($this->photo_id_tr) {
            return str_replace("\\", "/", $this->phototr->url());
        }

        return asset("trash/04.jpg");
    }

    public function getMp4()
    {
        $isTurkish = _clang() == "tr";

        if ($isTurkish && $this->video_id_tr) {
            return str_replace("\\", "/", $this->mp4tr->url());
        }

        if (!$isTurkish && $this->video_id_en) {
            return str_replace("\\", "/", $this->mp4en->url());
        }

        if ($this->video_id_tr) {
            return str_replace("\\", "/", $this->mp4tr->url());
        }

        return asset("trash/video.mp4");
    }

    public function getMediaType()
    {
        return ($this->video_id_tr or $this->video_id_en) ? true : false;
    }


}
