<?php

namespace App\Packages\Redirect;

use App\Packages\Redirect\Requests\RedirectRequest;
use App\Packages\Redirect\Models\Redirect;
use Carbon\Carbon;
use Nette\Admin\Models\Page;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class RedirectController extends BaseController
{
    public $cTitle = 'Yönlendiriciler';

    public $cMenuKey = 'redirect';
    public $cModel = Redirect::class;
    public $cModelName = 'Redirect';

    public $cKey = 'redirect';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.redirect.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'redirect.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.redirect.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.redirect.store';
    public $cCreatePermission = 'redirect.create';
    public $cCreateBlade = 'Redirect::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.redirect.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.redirect.update';
    public $cEditPermission = 'redirect.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.redirect.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'redirect.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.redirect.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.redirect.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'redirect.delete';
    //endregion

    public $cFields = [
        'id'   => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name' => ['name' => 'Adı'],
    ];

    public $cFieldMutators = [
        //'created_at' => 'globalDate',
        //'name' => ['method' => 'frontUrl', 'parameter' => 'object']
    ];

    public $cSidebarModules = [
        'Redirect::_partials.status',
        '_Common::info',
    ];


    public $cModuleFiles = [
        [
            'name'         => 'PNG Gorseli',
            'type'         => 'img',
            'key'          => 'redirect',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],
        [
            'name'         => 'Banner Gorseli',
            'type'         => 'img',
            'key'          => 'redirect_banner',
            'database_key' => 'banner_id',
            'multiple'     => false,
            'attach_func'  => 'banner',
        ],
    ];

    public $cFilterable = false;


    public function __construct()
    {
        parent::__construct();
    }


    public function store(RedirectRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);
        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(RedirectRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
