<?php

namespace App\Packages\Redirect\Models;


use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\Page;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;


class Redirect extends BaseModel
{
    use SoftDeletes;
    use MultiLingualModel;
    use Sluggable;
    use SlugTrait;

    protected $table = 'redirects';

    protected $multiLingualFillable = [
        'link',
        'content'
    ];

    protected static function boot()
    {
        parent::boot();
    }

    protected $fillable = [
        'name',
        'author',
        'edit_author',
        'status',
        'publish_status',
        'photo_id',
        'banner_id',
        'created_at',
        'order_number'
    ];

    protected $hidden = [

    ];

    public static $slug = [
//        'name' => 'slug',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = ['photo', 'banner'];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];


    public static $checks = [
        'status',
    ];

    public static $zeros = [

    ];

    public static $rules = [
        'name' => 'required',
    ];

    public static $multiLingualRules = [
        'link' => 'required',
    ];

    public static $attr = [
        'name' => 'Adı',
    ];

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function banner()
    {
        return $this->hasOne(Media::class, 'id', 'banner_id');
    }

    public function getPhoto()
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : asset('trash/cta-horeca.png');
    }

    public function getBanner()
    {
        return $this->banner_id ? str_replace("\\", "/", $this->banner->url()) : asset('trash/cta-horeca.jpg');
    }

}
