<?php

Route::group(['prefix' => 'page', 'as' => 'page.','namespace' => 'App\Packages\Page'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'PageController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'PageController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'PageController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'PageController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'PageController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'PageController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'PageController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'PageController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'PageController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'PageController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',   'uses' => 'PageController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',   'uses' => 'PageController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',   'uses' => 'PageController@deleteMedia']);
});