<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePagesTable extends Migration
{
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('pages', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name',false);
            $table->multiLangString('slug',true);
            $table->multiLangText('spot',true);
            $table->multiLangText('content',true);
            $table->bigInteger('photo_id')->nullable();
            $table->boolean('status')->default(false);
            $table->boolean('lock')->default(false);
            $table->integer('order_number')->default(0);
            $table->string('key')->nullable();
            $table->string('subkey')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->index([
                'status','order_number','photo_id'
            ]);

        });
        $schema->create('page_gallery', function(ExtendedBlueprint $table){
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->longText('title')->nullable();
            $table->longText('caption')->nullable();
            $table->text('source')->nullable();
            $table->integer('order')->default(0);
            $table->integer('page_id')->unsigned();
            $table->foreign('page_id')->references('id')->on('pages')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('media_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('page_gallery');
        Schema::dropIfExists('pages');
    }
}
