<?php

namespace App\Packages\Page;

use App\Packages\Page\Models\Page;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use UploadManager;

use App\Packages\Page\Requests\PageRequest;

class PageController extends AdminBaseController
{
    public $cTitle = 'Sayfalar';
    public $cMenuKey = 'page';

    public $cBreadcrumb = [
        'name'  => 'Sayfalar',
        'route' => 'admin.page.index',
    ];

    public $cModel = Page::class;
    public $cModelName = 'Sayfa';

    public $cKey = 'page';

    public $cBladeKey = null;

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.page.index';
    public $cIndexTitle = 'Liste';

    public $cShow = false;
    public $cShowRoute = 'admin.page.show';
    public $cShowTitle = 'Görüntüle';
    public $cShowBlade = null;
    public $cShowPermission = 'page.view';


    public $cCreate = true;
    public $cCreateBlade = 'Page::create';
    public $cCreateRoute = 'admin.page.create';
    public $cCreateTitle = 'Yeni ';
    public $cCreateMethodRoute = 'admin.page.store';
    public $cCreatePermission = 'page.create';

    public $cEdit = true;
    public $cEditRoute = 'admin.page.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.page.update';
    public $cEditPermission = 'page.edit';

    public $cPublish = false;
    public $cPublishRoute = 'admin.page.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'page.publish';

    public $cDelete = true;
    public $cDeleteRoute = 'admin.page.destroy';
    public $cDeletePermission = 'page.delete';

    public $cBatchDelete = true;
    public $cBatchDeleteRoute = 'admin.page.batchdestroy';

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.page.orderable';

    public $cSortable = false;
    public $cSortableColumn = 'order_number';


    public $cOrderMediaRoute = 'admin.page.ordermedia';
    public $cUpdateMediaRoute = 'admin.page.updatemedia';
    public $cDeleteMediaRoute = 'admin.page.deletemedia';


    public $cFields = [
        'id'      => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr' => ['name' => 'Sayfa Adı'],
        'key'     => ['name' => 'Anahtar', 'size' => 'medium'],
        'lock'    => ['name' => 'Kilitli', 'size' => 'mini'],
    ];
    public $cMultiLangFields = [
        'name' => 'İsim',
    ];

    public $cFieldMutators = [
        'lock' => 'isLocked',
    ];

    public $cFilterable = false;
    public $filters = [
        'field' => [
            'name'     => 'Sayfa Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public $cModuleFiles = [
        [
            'name'         => 'Sayfa resmi',
            'type'         => 'img',
            'key'          => 'page',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],
        [
            'name'        => 'Sayfa resimleri',
            'type'        => 'img',
            'key'         => 'page_images_different',
            'multiple'    => true,
            'attach_func' => 'images',
        ],

    ];

    public $cSidebarModules = [
        'admin::_partials.sidebar.elements.page',
        'Page::_common.status',
    ];

    public function __construct()
    {
        parent::__construct();
    }


    public function store(PageRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(PageRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
