<?php

namespace App\Packages\Page\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Multilingual\Traits\MultiLingualModel;
use Nette\Upload\Models\Media;

class Page extends BaseModel
{
    protected $table = 'pages';

    use SoftDeletes;
    use Sluggable;
    use SlugTrait;
    use MultiLingualModel;

    protected $fillable = [
        'photo_id',
        'status',
        'lock',
        'order_number',
        'meta',
        'key',
        'subkey',
        'spot',
        'content'
    ];

    protected $multiLingualFillable = [
        'name',
        'slug',
        'content',
        'spot'
    ];

    protected $with = ['photo'];

    protected $casts = ['meta' => 'array'];


    public static $multiLingualSlug = [
        'name' => 'slug'
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public static $checks = [
        'is_homepage',
        'status'
    ];

    public static $rules = [];
    public static $attr = [];

    public static $multiLingualRules = [
        'name' => 'required',
   //     'content' => 'required',
     //   'spot' => 'required'
    ];

    public static $multiLingualAttr = [
        'name' => 'Sayfa adı',
        'content' => 'İçerik',
        'spot' => 'Spot'
    ];

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto()
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : null;
    }

    public function images()
    {
        return $this->belongsToMany(Media::class, 'page_gallery', 'page_id', 'media_id')->withPivot('title', 'caption', 'order', 'source')->orderBy('page_gallery.order', 'ASC');
    }
}
