<?php

namespace App\Packages\Newsletter;

use App\Packages\Newsletter\Models\Newsletter;
use App\Packages\newsletter\Requests\NewsletterRequest;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class NewsletterController extends BaseController
{
    public $cTitle = 'Bültenler';

    public $cMenuKey = 'newsletter';
    public $cModel = Newsletter::class;
    public $cModelName = 'Bülten';

    public $cKey = 'newsletter';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.newsletter.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'newsletter.view';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.newsletter.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'newsletter.delete';
    //endregion

    public $cFields = [
        'id' => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'email' => ['name' => 'Email'],
        'created_at' => ['name' => 'Tarih', 'size' => 'medium'],
    ];

    public $cFieldMutators = [
//        'newsletter_id' => 'videonewsletterName',
        'created_at' => 'globalDate',
    ];

    public $cSidebarModules = [
    ];


    public $cModuleFiles = [
    ];

    public $cFilterable = false;


    public function __construct()
    {
        parent::__construct();
    }

    public function store(NewsletterRequest $request)
    {
        return parent::_store($request);
    }

    public function update(NewsletterRequest $request, $id)
    {
        return parent::_update($request, $id);
    }

}
