<?php

namespace App\Packages\Newsletter\Models;



use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Newsletter extends BaseModel
{

    protected $table = 'newsletter';

    protected $fillable = [
        'email',
        'ip'

    ];

    protected $hidden = [

    ];

    protected $casts = [
//        'meta' => 'array'
    ];

    protected $with = [];

    protected $appends = ['url', 'date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
        //'name' => 'slug'
    ];

    public static $multiLingualSlug = [
//        'name' => 'slug'
    ];

    public static $checks = [
        'status',
    ];

    public static $zeros = [

    ];

    public static $rules = [
        'email' => 'required|email|unique:newsletter',
//        'g-recaptcha-response' => 'required|captcha'
    ];

    public static $multiLingualRules = [
//        'name' => 'required',
    ];

    public static $attr = [
        'email' => 'E-mail',
        'g-recaptcha-response' => 'Güvenlik kodu'
    ];


    public function getUrlAttribute()
    {
        return '#';
    }

}
