<?php

namespace App\Http\Controllers;

use App\Packages\Newsletter\Models\Newsletter;
use App\Packages\Newsletter\Requests\NewsletterRequest;
use App\Packages\Page\Models\Page;
use App\Packages\Redirect\Models\Redirect;
use App\Packages\Slider\Models\Slider;
use App\Packages\Widget\Models\Widget;
use Illuminate\Support\Facades\Cache;
use View;
use Data;

class FrontBaseController extends Controller
{
    public function __construct()
    {
        /*$menuCategories = Category::published()->orderBy('order_number', 'ASC')->get();View::share('menuCategories', $menuCategories);*/
    }

    public function index()
    {
        return view("main")
            ->with("current_menu", $this->getCurrentMenu())
            ->with("sliders", $this->getSliders())
            ->with("redirects", $this->getRedirects())
            ->with("pages", $this->getPages())
            ->with("policies", $this->getPolicy())
            ->with("widgets", $this->getWidgets());
    }

    public function getSliders()
    {
        return Cache::remember("sliders", 1440, function () {
            return Slider::published()->orderBy("order_number")->get();
        });
    }

    public function getCurrentMenu()
    {
        return Cache::remember("current-menu-key", 99999, function () {
            return "home";
        });
    }

    public function getRedirects()
    {
        return Cache::remember("redirects", 1440, function () {
            $redirects = Redirect::published()->orderBy("order_number")->take(2)->get();

            $redirects->transform(function ($redirect) {
                $simpleDomain = preg_replace('/^(https?:\/\/)?(www\.)?/', '', $redirect->link);

                $redirect->link_view = $simpleDomain;

                return $redirect;
            });

            return $redirects;
        });
    }

    public function getPages()
    {
        return Cache::remember("pages", 1440, function () {
            return [
                "reveal" => Page::where("key", "reveal-card")->first(),
                "4cards" => Page::where("key", "4-cards")->first(),
            ];
        });
    }

    public function newsletter(NewsletterRequest $request)
    {
        $input       = $request->all();
        $input["ip"] = request()->ip();
        $table       = Newsletter::create($input);

        return redirect()->back()->with("success", trans("partials.success_newsletter"));
    }

    public function getPolicy()
    {
        return Cache::remember("policies", 1440, function () {
            return [
                "pdpl"      => Page::where("key", "pdpl")->first(),
                "confident" => Page::where("key", "confidentiality-agreement")->first(),
            ];
        });
    }

    public function getWidgets()
    {
        return Cache::remember("widgets", 1440, function () {
            return Widget::published()->orderBy("order_number")->take(4)->get();
        });
    }
}
