<?php


use App\Packages\Donate\Models\Donate;
use App\Packages\DonateForm\Models\DonateForm;

if (!function_exists('_asset')) {
    function _asset($path)
    {
        return config('app.asset_url') . '/' . $path;
    }
}

if (!function_exists('checkMenu')) {
    function checkMenu($value, $current, $return = 'class="active"')
    {
        return $value === $current ? $return : '';
    }
}

if (!function_exists('checkLeftMenu')) {
    function checkLeftMenu($value, $current, $return = 'class="selected"')
    {
        return $value === $current ? $return : '';
    }
}

if (!function_exists('checkLeftColorMenu')) {
    function checkLeftColorMenu($value, $current, $return = 'class="selected"')
    {
        return $value === $current ? $return : '';
    }
}

if (!function_exists('carbonize')) {
    function carbonize($datetime, $format = 'H:i')
    {
        return \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $datetime)->translatedFormat($format);
    }
}


if (!function_exists('replacePhotoUrl')) {
    function replacePhotoUrl($url)
    {
        $photo = str_replace('\\', '/', $url);

        return $photo;
    }
}


if (!function_exists('replaceRoute')) {
    function replaceRoute($route)
    {
        $newRoute = '';

        return $newRoute;
    }
}


if (!function_exists('galleryFirstImage')) {
    function galleryFirstImage($pageKey)
    {
        $page = \App\Packages\Page\Models\Page::published()->where('key', $pageKey)->first();
        foreach ($page->images as $image) {
            $image = str_replace('\\', '/', $image->url);
        }
        return $image;
    }
}

if (!function_exists('countryFindName')) {
    function countryFindName($id)
    {
        $country = \App\Packages\Country\Models\Country::published()->where('id', $id)->first();
        return $country->name;
    }
}

if (!function_exists('productFindName')) {
    function productFindName($id)
    {
        $product = \App\Packages\Product\Models\Product::published()->where('id', $id)->first();
        $product = $product->name.', ';
        return $product;
    }
}




